# Django settings for test_project project

DEBUG = True

# We are not really using a relational database, but tests fail without
# defining it because flush command is being run, which expects it
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': ':memory:',
    }
}

# Make this unique, and don't share it with anybody
SECRET_KEY = 'sq=uf!nqw=aibl+y1&5pp=)b7pc=c$4hnh$om*_c48r)^t!ob)'

MIDDLEWARE_CLASSES = (
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
)

ROOT_URLCONF = 'test_project.urls'

AUTHENTICATION_BACKENDS = (
    'mongoengine.django.auth.MongoEngineBackend',
)

SESSION_ENGINE = 'mongoengine.django.sessions'

TEST_RUNNER = 'tastypie_mongoengine.test_runner.MongoEngineTestSuiteRunner'

INSTALLED_APPS = (
    'tastypie',
    'tastypie_mongoengine',
    'test_project.test_app',
)

MONGO_DATABASE_NAME = 'test_project'

import mongoengine
mongoengine.connect(MONGO_DATABASE_NAME)

if mongoengine.VERSION >= (0, 8, 0):
    AUTH_USER_MODEL = 'mongo_auth.MongoUser'
    INSTALLED_APPS = (
        'mongoengine.django.mongo_auth',
    ) + INSTALLED_APPS
