#!/usr/bin/env python
from setuptools import setup


setup(
    name='django-templates-i18n',
    version='0.1.0',
    description='Translatable templates',
    long_description=open('README.rst').read(),
    author='Pragmatic Mates',
    author_email='info@pragmaticmates.com',
    maintainer='Pragmatic Mates',
    maintainer_email='info@pragmaticmates.com',
    url='https://github.com/PragmaticMates/django-templates-i18n',
    packages=[
        'templates_i18n',
    ],
    include_package_data=True,
    install_requires=('South', 'django_modeltranslation', 'django'),
    classifiers=[
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.5',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Operating System :: OS Independent',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'Framework :: Django',
        'License :: OSI Approved :: BSD License',
        'Development Status :: 3 - Alpha'
    ],
    license='BSD License',
    keywords = "django templates translation i18n",
)
