import os
from tethys_apps.base.persistent_store import get_persistent_store_engine as gpse


def get_persistent_store_engine(persistent_store_name):
    """
    Returns an SQLAlchemy engine object for the persistent store name provided.
    """
    # Derive app name
    app_name = os.path.split(os.path.dirname(os.path.dirname(__file__)))[1]

    # Get engine
    return gpse(app_name, persistent_store_name)