/*
 * Decompiled with CFR 0.152.
 */
package com.highcharts.export.pool;

import com.highcharts.export.pool.ObjectFactory;
import com.highcharts.export.server.Server;
import com.highcharts.export.server.ServerState;
import com.highcharts.export.util.TempDir;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.PostConstruct;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class ServerObjectFactory
implements ObjectFactory<Server> {
    public String exec;
    public String script;
    private String host;
    private int basePort;
    private int readTimeout;
    private int connectTimeout;
    private int maxTimeout;
    private static HashMap<Integer, PortStatus> portUsage = new HashMap();
    protected static Logger logger = Logger.getLogger((String)"pool");

    @Override
    public Server create() {
        logger.debug((Object)("in makeObject, " + this.exec + ", " + this.script + ", " + this.host));
        Integer port = this.getAvailablePort();
        portUsage.put(port, PortStatus.BUSY);
        return new Server(this.exec, this.script, this.host, port, this.connectTimeout, this.readTimeout, this.maxTimeout);
    }

    @Override
    public boolean validate(Server server) {
        boolean isValid = false;
        try {
            if (server.getState() != ServerState.IDLE) {
                logger.debug((Object)"server didn't pass validation");
                return false;
            }
            String result = server.request("{\"status\":\"isok\"}");
            if (result.indexOf("OK") > -1) {
                isValid = true;
                logger.debug((Object)"server passed validation");
            } else {
                logger.debug((Object)"server didn't pass validation");
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error while validating object in Pool: " + e.getMessage()));
        }
        return isValid;
    }

    @Override
    public void destroy(Server server) {
        ServerObjectFactory.releasePort(server.getPort());
        server.cleanup();
    }

    @Override
    public void activate(Server server) {
        server.setState(ServerState.ACTIVE);
    }

    @Override
    public void passivate(Server server) {
        server.setState(ServerState.IDLE);
    }

    public static void releasePort(Integer port) {
        logger.debug((Object)("Releasing port " + port));
        portUsage.put(port, PortStatus.FREE);
    }

    public Integer getAvailablePort() {
        for (Map.Entry<Integer, PortStatus> entry : portUsage.entrySet()) {
            if (PortStatus.FREE != entry.getValue()) continue;
            logger.debug((Object)("Portusage " + portUsage.toString()));
            return entry.getKey();
        }
        logger.debug((Object)("Nothing free in Portusage " + portUsage.toString()));
        return this.basePort + portUsage.size();
    }

    public String getExec() {
        return this.exec;
    }

    public void setExec(String exec) {
        this.exec = exec;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getBasePort() {
        return this.basePort;
    }

    public void setBasePort(int basePort) {
        this.basePort = basePort;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getMaxTimeout() {
        return this.maxTimeout;
    }

    public void setMaxTimeout(int maxTimeout) {
        this.maxTimeout = maxTimeout;
    }

    @PostConstruct
    public void afterBeanInit() {
        String jarLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            jarLocation = URLDecoder.decode(jarLocation, "utf-8");
            jarLocation = new File(jarLocation).getCanonicalPath();
        }
        catch (UnsupportedEncodingException ueex) {
            logger.error((Object)ueex);
        }
        catch (IOException ioex) {
            logger.error((Object)ioex);
        }
        try {
            JarFile jar = new JarFile(jarLocation);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("phantomjs/")) continue;
                Path path = Paths.get(TempDir.getTmpDir().toString(), name);
                if (name.endsWith("/")) {
                    Files.createDirectories(path, new FileAttribute[0]);
                    continue;
                }
                File file = Files.createFile(path, new FileAttribute[0]).toFile();
                InputStream in = jar.getInputStream(entry);
                IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(file));
            }
        }
        catch (IOException ioex) {
            logger.error((Object)ioex);
        }
    }

    private static enum PortStatus {
        BUSY,
        FREE;

    }
}

