/**
 * jqPlot
 * Pure JavaScript plotting plugin using jQuery
 *
 * Version: 1.0.0a_r701
 *
 * Copyright (c) 2009-2011 Chris Leonello
 * jqPlot is currently available for use in all personal or commercial projects 
 * under both the MIT (http://www.opensource.org/licenses/mit-license.php) and GPL 
 * version 2.0 (http://www.gnu.org/licenses/gpl-2.0.html) licenses. This means that you can 
 * choose the license that best suits your project and use it accordingly. 
 *
 * Although not required, the author would appreciate an email letting him 
 * know of any substantial use of jqPlot.  You can reach the author at: 
 * chris at jqplot dot com or see http://www.jqplot.com/info.php .
 *
 * If you are feeling kind and generous, consider supporting the project by
 * making a donation at: http://www.jqplot.com/donate.php .
 *
 * sprintf functions contained in jqplot.sprintf.js by Ash Searle:
 *
 *     version 2007.04.27
 *     author Ash Searle
 *     http://hexmen.com/blog/2007/03/printf-sprintf/
 *     http://hexmen.com/js/sprintf.js
 *     The author (Ash Searle) has placed this code in the public domain:
 *     "This code is unrestricted: you are free to use it however you like."
 * 
 */
(function(e){e.jqplot.FunnelRenderer=function(){e.jqplot.LineRenderer.call(this)};e.jqplot.FunnelRenderer.prototype=new e.jqplot.LineRenderer();e.jqplot.FunnelRenderer.prototype.constructor=e.jqplot.FunnelRenderer;e.jqplot.FunnelRenderer.prototype.init=function(q,u){this.padding={top:20,right:20,bottom:20,left:20};this.sectionMargin=6;this.fill=true;this.shadowOffset=2;this.shadowAlpha=0.07;this.shadowDepth=5;this.highlightMouseOver=true;this.highlightMouseDown=false;this.highlightColors=[];this.widthRatio=0.2;this.lineWidth=2;this.dataLabels="percent";this.showDataLabels=false;this.dataLabelFormatString=null;this.dataLabelThreshold=3;this.tickRenderer=e.jqplot.FunnelTickRenderer;if(q.highlightMouseDown&&q.highlightMouseOver==null){q.highlightMouseOver=false}e.extend(true,this,q);this._highlightedPoint=null;this._bases=[];this._atot;this._areas=[];this._lengths=[];this._angle;this._dataIndices=[];this._unorderedData=e.extend(true,[],this.data);var p=e.extend(true,[],this.data);for(var s=0;s<p.length;s++){p[s].push(s)}this.data.sort(function(w,v){return v[1]-w[1]});p.sort(function(w,v){return v[1]-w[1]});for(var s=0;s<p.length;s++){this._dataIndices.push(p[s][2])}if(this.highlightColors.length==0){for(var s=0;s<this.seriesColors.length;s++){var r=e.jqplot.getColorComponents(this.seriesColors[s]);var n=[r[0],r[1],r[2]];var t=n[0]+n[1]+n[2];for(var o=0;o<3;o++){n[o]=(t>570)?n[o]*0.8:n[o]+0.4*(255-n[o]);n[o]=parseInt(n[o],10)}this.highlightColors.push("rgb("+n[0]+","+n[1]+","+n[2]+")")}}u.postParseOptionsHooks.addOnce(l);u.postInitHooks.addOnce(g);u.eventListenerHooks.addOnce("jqplotMouseMove",a);u.eventListenerHooks.addOnce("jqplotMouseDown",b);u.eventListenerHooks.addOnce("jqplotMouseUp",k);u.eventListenerHooks.addOnce("jqplotClick",f);u.eventListenerHooks.addOnce("jqplotRightClick",m);u.postDrawHooks.addOnce(h)};e.jqplot.FunnelRenderer.prototype.setGridData=function(p){var o=0;var q=[];for(var n=0;n<this.data.length;n++){o+=this.data[n][1];q.push([this.data[n][0],this.data[n][1]])}for(var n=0;n<q.length;n++){q[n][1]=q[n][1]/o}this._bases=new Array(q.length+1);this._lengths=new Array(q.length);this.gridData=q};e.jqplot.FunnelRenderer.prototype.makeGridData=function(p,q){var o=0;var r=[];for(var n=0;n<this.data.length;n++){o+=this.data[n][1];r.push([this.data[n][0],this.data[n][1]])}for(var n=0;n<r.length;n++){r[n][1]=r[n][1]/o}this._bases=new Array(r.length+1);this._lengths=new Array(r.length);return r};e.jqplot.FunnelRenderer.prototype.drawSection=function(o,q,p,t){var u=this.fill;var n=this.lineWidth;o.save();if(t){for(var s=0;s<this.shadowDepth;s++){o.save();o.translate(this.shadowOffset*Math.cos(this.shadowAngle/180*Math.PI),this.shadowOffset*Math.sin(this.shadowAngle/180*Math.PI));r()}}else{r()}function r(){o.beginPath();o.fillStyle=p;o.strokeStyle=p;o.lineWidth=n;o.moveTo(q[0][0],q[0][1]);for(var v=1;v<4;v++){o.lineTo(q[v][0],q[v][1])}o.closePath();if(u){o.fill()}else{o.stroke()}}if(t){for(var s=0;s<this.shadowDepth;s++){o.restore()}}o.restore()};e.jqplot.FunnelRenderer.prototype.draw=function(H,C,K,q){var Z;var M=(K!=undefined)?K:{};var z=0;var w=0;var S=1;this._areas=[];if(K.legendInfo&&K.legendInfo.placement=="insideGrid"){var P=K.legendInfo;switch(P.location){case"nw":z=P.width+P.xoffset;break;case"w":z=P.width+P.xoffset;break;case"sw":z=P.width+P.xoffset;break;case"ne":z=P.width+P.xoffset;S=-1;break;case"e":z=P.width+P.xoffset;S=-1;break;case"se":z=P.width+P.xoffset;S=-1;break;case"n":w=P.height+P.yoffset;break;case"s":w=P.height+P.yoffset;S=-1;break;default:break}}var u=(S==1)?this.padding.left+z:this.padding.left;var G=(S==1)?this.padding.top+w:this.padding.top;var N=(S==-1)?this.padding.right+z:this.padding.right;var p=(S==-1)?this.padding.bottom+w:this.padding.bottom;var Q=(M.shadow!=undefined)?M.shadow:this.shadow;var r=(M.showLine!=undefined)?M.showLine:this.showLine;var D=(M.fill!=undefined)?M.fill:this.fill;var I=H.canvas.width;var O=H.canvas.height;this._bases[0]=I-u-N;var J=this._length=O-G-p;var s=this._bases[0]*this.widthRatio;this._atot=J/2*(this._bases[0]+this._bases[0]*this.widthRatio);this._angle=Math.atan((this._bases[0]-s)/2/J);for(Z=0;Z<C.length;Z++){this._areas.push(C[Z][1]*this._atot)}var F,ab,X,R=0;var o=0.0001;for(Z=0;Z<this._areas.length;Z++){F=this._areas[Z]/this._bases[Z];ab=999999;this._lengths[Z]=F;X=0;while(ab>this._lengths[Z]*o&&X<100){this._lengths[Z]=this._areas[Z]/(this._bases[Z]-this._lengths[Z]*Math.tan(this._angle));ab=Math.abs(this._lengths[Z]-F);this._bases[Z+1]=this._bases[Z]-(2*this._lengths[Z]*Math.tan(this._angle));F=this._lengths[Z];X++}R+=this._lengths[Z]}this._vertices=new Array(C.length);var af=[u,G],ae=[u+this._bases[0],G],ad=[u+(this._bases[0]-this._bases[this._bases.length-1])/2,G+this._length],ac=[ad[0]+this._bases[this._bases.length-1],ad[1]];function W(ah){var x=(af[1]-ad[1])/(af[0]-ad[0]);var v=af[1]-x*af[0];var ai=ah+af[1];return[(ai-v)/x,ai]}function E(ah){var x=(ae[1]-ac[1])/(ae[0]-ac[0]);var v=ae[1]-x*ae[0];var ai=ah+ae[1];return[(ai-v)/x,ai]}var U=z,T=w;var aa=0,n=0;for(Z=0;Z<C.length;Z++){this._vertices[Z]=new Array();var V=this._vertices[Z];var B=this.sectionMargin;if(Z==0){n=0}if(Z==1){n=B/3}else{if(Z>0&&Z<C.length-1){n=B/2}else{if(Z==C.length-1){n=2*B/3}}}V.push(W(aa+n));V.push(E(aa+n));aa+=this._lengths[Z];if(Z==0){n=-2*B/3}else{if(Z>0&&Z<C.length-1){n=-B/2}else{if(Z==C.length-1){n=0}}}V.push(E(aa+n));V.push(W(aa+n))}if(this.shadow){var ag="rgba(0,0,0,"+this.shadowAlpha+")";for(var Z=0;Z<C.length;Z++){this.renderer.drawSection.call(this,H,this._vertices[Z],ag,true)}}for(var Z=0;Z<C.length;Z++){var V=this._vertices[Z];this.renderer.drawSection.call(this,H,V,this.seriesColors[Z]);if(this.showDataLabels&&C[Z][1]*100>=this.dataLabelThreshold){var L,Y;if(this.dataLabels=="label"){L=this.dataLabelFormatString||"%s";Y=e.jqplot.sprintf(L,C[Z][0])}else{if(this.dataLabels=="value"){L=this.dataLabelFormatString||"%d";Y=e.jqplot.sprintf(L,this.data[Z][1])}else{if(this.dataLabels=="percent"){L=this.dataLabelFormatString||"%d%%";Y=e.jqplot.sprintf(L,C[Z][1]*100)}else{if(this.dataLabels.constructor==Array){L=this.dataLabelFormatString||"%s";Y=e.jqplot.sprintf(L,this.dataLabels[this._dataIndices[Z]])}}}}var t=(this._radius)*this.dataLabelPositionFactor+this.sliceMargin+this.dataLabelNudge;var U=(V[0][0]+V[1][0])/2+this.canvas._offsets.left;var T=(V[1][1]+V[2][1])/2+this.canvas._offsets.top;var A=e('<span class="jqplot-funnel-series jqplot-data-label" style="position:absolute;">'+Y+"</span>").insertBefore(q.eventCanvas._elem);U-=A.width()/2;T-=A.height()/2;U=Math.round(U);T=Math.round(T);A.css({left:U,top:T})}}};e.jqplot.FunnelAxisRenderer=function(){e.jqplot.LinearAxisRenderer.call(this)};e.jqplot.FunnelAxisRenderer.prototype=new e.jqplot.LinearAxisRenderer();e.jqplot.FunnelAxisRenderer.prototype.constructor=e.jqplot.FunnelAxisRenderer;e.jqplot.FunnelAxisRenderer.prototype.init=function(n){this.tickRenderer=e.jqplot.FunnelTickRenderer;e.extend(true,this,n);this._dataBounds={min:0,max:100};this.min=0;this.max=100;this.showTicks=false;this.ticks=[];this.showMark=false;this.show=false};e.jqplot.FunnelLegendRenderer=function(){e.jqplot.TableLegendRenderer.call(this)};e.jqplot.FunnelLegendRenderer.prototype=new e.jqplot.TableLegendRenderer();e.jqplot.FunnelLegendRenderer.prototype.constructor=e.jqplot.FunnelLegendRenderer;e.jqplot.FunnelLegendRenderer.prototype.init=function(n){this.numberRows=null;this.numberColumns=null;e.extend(true,this,n)};e.jqplot.FunnelLegendRenderer.prototype.draw=function(){var q=this;if(this.show){var y=this._series;var B="position:absolute;";B+=(this.background)?"background:"+this.background+";":"";B+=(this.border)?"border:"+this.border+";":"";B+=(this.fontSize)?"font-size:"+this.fontSize+";":"";B+=(this.fontFamily)?"font-family:"+this.fontFamily+";":"";B+=(this.textColor)?"color:"+this.textColor+";":"";B+=(this.marginTop!=null)?"margin-top:"+this.marginTop+";":"";B+=(this.marginBottom!=null)?"margin-bottom:"+this.marginBottom+";":"";B+=(this.marginLeft!=null)?"margin-left:"+this.marginLeft+";":"";B+=(this.marginRight!=null)?"margin-right:"+this.marginRight+";":"";this._elem=e('<table class="jqplot-table-legend" style="'+B+'"></table>');var F=false,x=false,n,v;var z=y[0];var o=new e.jqplot.ColorGenerator(z.seriesColors);if(z.show){var G=z.data;if(this.numberRows){n=this.numberRows;if(!this.numberColumns){v=Math.ceil(G.length/n)}else{v=this.numberColumns}}else{if(this.numberColumns){v=this.numberColumns;n=Math.ceil(G.length/this.numberColumns)}else{n=G.length;v=1}}var E,D,p,t,r,u,w,C;var A=0;for(E=0;E<n;E++){if(x){p=e('<tr class="jqplot-table-legend"></tr>').prependTo(this._elem)}else{p=e('<tr class="jqplot-table-legend"></tr>').appendTo(this._elem)}for(D=0;D<v;D++){if(A<G.length){u=this.labels[A]||G[A][0].toString();C=o.next();if(!x){if(E>0){F=true}else{F=false}}else{if(E==n-1){F=false}else{F=true}}w=(F)?this.rowSpacing:"0";t=e('<td class="jqplot-table-legend" style="text-align:center;padding-top:'+w+';"><div><div class="jqplot-table-legend-swatch" style="border-color:'+C+';"></div></div></td>');r=e('<td class="jqplot-table-legend" style="padding-top:'+w+';"></td>');if(this.escapeHtml){r.text(u)}else{r.html(u)}if(x){r.prependTo(p);t.prependTo(p)}else{t.appendTo(p);r.appendTo(p)}F=true}A++}}}}return this._elem};function c(r,q,o){o=o||{};o.axesDefaults=o.axesDefaults||{};o.legend=o.legend||{};o.seriesDefaults=o.seriesDefaults||{};var n=false;if(o.seriesDefaults.renderer==e.jqplot.FunnelRenderer){n=true}else{if(o.series){for(var p=0;p<o.series.length;p++){if(o.series[p].renderer==e.jqplot.FunnelRenderer){n=true}}}}if(n){o.axesDefaults.renderer=e.jqplot.FunnelAxisRenderer;o.legend.renderer=e.jqplot.FunnelLegendRenderer;o.legend.preDraw=true;o.sortData=false;o.seriesDefaults.pointLabels={show:false}}}function g(p,o,n){for(i=0;i<this.series.length;i++){if(this.series[i].renderer.constructor==e.jqplot.FunnelRenderer){if(this.series[i].highlightMouseOver){this.series[i].highlightMouseDown=false}}}this.target.bind("mouseout",{plot:this},function(q){j(q.data.plot)})}function l(n){for(var o=0;o<this.series.length;o++){this.series[o].seriesColors=this.seriesColors;this.series[o].colorGenerator=this.colorGenerator}}function d(r,q,p){var o=r.series[q];var n=r.plugins.funnelRenderer.highlightCanvas;n._ctx.clearRect(0,0,n._ctx.canvas.width,n._ctx.canvas.height);o._highlightedPoint=p;r.plugins.funnelRenderer.highlightedSeriesIndex=q;o.renderer.drawSection.call(o,n._ctx,o._vertices[p],o.highlightColors[p],false)}function j(p){var n=p.plugins.funnelRenderer.highlightCanvas;n._ctx.clearRect(0,0,n._ctx.canvas.width,n._ctx.canvas.height);for(var o=0;o<p.series.length;o++){p.series[o]._highlightedPoint=null}p.plugins.funnelRenderer.highlightedSeriesIndex=null;p.target.trigger("jqplotDataUnhighlight")}function a(r,q,u,t,s){if(t){var p=[t.seriesIndex,t.pointIndex,t.data];var o=jQuery.Event("jqplotDataMouseOver");o.pageX=r.pageX;o.pageY=r.pageY;s.target.trigger(o,p);if(s.series[p[0]].highlightMouseOver&&!(p[0]==s.plugins.funnelRenderer.highlightedSeriesIndex&&p[1]==s.series[p[0]]._highlightedPoint)){var n=jQuery.Event("jqplotDataHighlight");n.pageX=r.pageX;n.pageY=r.pageY;s.target.trigger(n,p);d(s,p[0],p[1])}}else{if(t==null){j(s)}}}function b(q,p,t,s,r){if(s){var o=[s.seriesIndex,s.pointIndex,s.data];if(r.series[o[0]].highlightMouseDown&&!(o[0]==r.plugins.funnelRenderer.highlightedSeriesIndex&&o[1]==r.series[o[0]]._highlightedPoint)){var n=jQuery.Event("jqplotDataHighlight");n.pageX=q.pageX;n.pageY=q.pageY;r.target.trigger(n,o);d(r,o[0],o[1])}}else{if(s==null){j(r)}}}function k(p,o,s,r,q){var n=q.plugins.funnelRenderer.highlightedSeriesIndex;if(n!=null&&q.series[n].highlightMouseDown){j(q)}}function f(q,p,t,s,r){if(s){var o=[s.seriesIndex,s.pointIndex,s.data];var n=jQuery.Event("jqplotDataClick");n.pageX=q.pageX;n.pageY=q.pageY;r.target.trigger(n,o)}}function m(r,q,u,t,s){if(t){var p=[t.seriesIndex,t.pointIndex,t.data];var n=s.plugins.funnelRenderer.highlightedSeriesIndex;if(n!=null&&s.series[n].highlightMouseDown){j(s)}var o=jQuery.Event("jqplotDataRightClick");o.pageX=r.pageX;o.pageY=r.pageY;s.target.trigger(o,p)}}function h(){this.plugins.funnelRenderer={};this.plugins.funnelRenderer.highlightCanvas=new e.jqplot.GenericCanvas();var o=e(this.targetId+" .jqplot-data-label");if(o.length){e(o[0]).before(this.plugins.funnelRenderer.highlightCanvas.createElement(this._gridPadding,"jqplot-funnelRenderer-highlight-canvas",this._plotDimensions))}else{this.eventCanvas._elem.before(this.plugins.funnelRenderer.highlightCanvas.createElement(this._gridPadding,"jqplot-funnelRenderer-highlight-canvas",this._plotDimensions))}var n=this.plugins.funnelRenderer.highlightCanvas.setContext()}e.jqplot.preInitHooks.push(c);e.jqplot.FunnelTickRenderer=function(){e.jqplot.AxisTickRenderer.call(this)};e.jqplot.FunnelTickRenderer.prototype=new e.jqplot.AxisTickRenderer();e.jqplot.FunnelTickRenderer.prototype.constructor=e.jqplot.FunnelTickRenderer})(jQuery);