from django.core.urlresolvers import reverse
from django.http import HttpResponsePermanentRedirect

try:
    from django.conf.urls import patterns, include, url
except ImportError:
    from django.conf.urls.defaults import patterns, include, url

from timepiece import views


urlpatterns = patterns('',
    # Redirect the base URL to the dashboard.
    url(r'^$', lambda r: HttpResponsePermanentRedirect(reverse('dashboard'))),
    url(r'^dashboard/(?:(?P<active_tab>progress|all-entries|online-users)/)?$',
        views.dashboard,
        name='dashboard'),
    url(r'^search/$',
        views.search,
        name='search'),

    # Active entry
    url(r'^entry/clock_in/$',
        views.clock_in,
        name='clock_in'),
    url(r'^entry/clock_out/$',
        views.clock_out,
        name='clock_out'),
    url(r'^entry/toggle_pause/$',
        views.toggle_pause,
        name='toggle_pause'),

    # Entries
    url(r'^entry/add/$',
        views.create_edit_entry,
        name='create_entry'),
    url(r'^entry/(?P<entry_id>\d+)/edit/$',
        views.create_edit_entry,
        name='edit_entry'),
    url(r'^entry/(?P<entry_id>\d+)/reject/$',
        views.reject_entry,
        name='reject_entry'),
    url(r'^entry/(?P<entry_id>\d+)/delete/$',
        views.delete_entry,
        name='delete_entry'),

    # Users
    url(r'^user/settings/$',
        views.edit_settings,
        name='edit_settings'),
    url(r'^user/$',
        views.list_users,
        name='list_users'),
    url(r'^user/create/$',
        views.create_edit_user,
        name='create_user'),
    url(r'^user/(?P<user_id>\d+)/$',
        views.view_user,
        name='view_user'),
    url(r'^user/(?P<user_id>\d+)/edit/$',
        views.create_edit_user,
        name='edit_user'),
    url(r'^user/(?P<user_id>\d+)/delete/$',
        views.DeleteUserView.as_view(),
        name='delete_user'),
    url(r'^user/(?P<user_id>\d+)/timesheet/' +
                '(?:(?P<active_tab>overview|all-entries|daily-summary)/)?$',
        views.view_user_timesheet,
        name='view_user_timesheet'),
    url(r'^user/(?P<user_id>\d+)/timesheet/reject/$',
        views.reject_user_timesheet,
        name='reject_user_timesheet'),
    url(r'^user/(?P<user_id>\d+)/timesheet/(?P<action>verify|approve)/$',
        views.change_user_timesheet,
        name='change_user_timesheet'),

    # Projects
    url(r'^project/$',
        views.list_projects,
        name='list_projects'),
    url(r'^project/create/$',
        views.create_edit_project,
        name='create_project'),
    url(r'^project/(?P<project_id>\d+)/$',
        views.view_project,
        name='view_project'),
    url(r'^project/(?P<project_id>\d+)/edit/$',
        views.create_edit_project,
        name='edit_project'),
    url(r'^project/(?P<project_id>\d+)/delete/$',
        views.DeleteProjectView.as_view(),
        name='delete_project'),
    url(r'^project/(?P<pk>\d+)/timesheet/$',
        views.ProjectTimesheet.as_view(),
        name='view_project_timesheet'),
    url(r'^project/(?P<pk>\d+)/timesheet/csv/$',
        views.ProjectTimesheetCSV.as_view(),
        name='view_project_timesheet_csv'),

    # Businesses
    url(r'^business/$',
        views.list_businesses,
        name='list_businesses'),
    url(r'^business/create/$',
        views.create_edit_business,
        name='create_business'),
    url(r'^business/(?P<business_id>\d+)/$',
        views.view_business,
        name='view_business'),
    url(r'^business/(?P<business_id>\d+)/edit/$',
        views.create_edit_business,
        name='edit_business'),
    url(r'^business/(?P<business_id>\d+)/delete/$',
        views.DeleteBusinessView.as_view(),
        name='delete_business'),

    # Project relationships
    url(r'^relationship/create/$',
        views.create_relationship,
        name='create_relationship'),
    url(r'^relationship/edit/$',
        views.edit_relationship,
        name='edit_relationship'),
    url(r'^relationship/delete/$',
        views.delete_relationship,
        name='delete_relationship'),

    # Reports
    url(r'^reports/hourly/$',
        views.HourlyReport.as_view(),
        name='report_hourly'),
    url(r'^reports/payroll/$',
        views.report_payroll_summary,
        name='report_payroll_summary'),
    url(r'^reports/billable_hours/$',
        views.BillableHours.as_view(),
        name='report_billable_hours'),
    url(r'^reports/productivity/$',
        views.report_productivity,
        name='report_productivity'),

    # Schedule
    url(r'^schedule/$',
        views.ScheduleView.as_view(),
        name='view_schedule'),
    url(r'^schedule/edit/$',
        views.EditScheduleView.as_view(),
        name='edit_schedule'),
    url(r'^schedule/ajax/$',
        views.ScheduleAjaxView.as_view(),
        name='ajax_schedule'),
    url(r'^schedule/ajax/(?P<assignment_id>\d+)/$',
        views.ScheduleDetailView.as_view(),
        name='ajax_schedule_detail'),

    # Contracts
    url(r'^contract/$',
        views.ContractList.as_view(),
        name='list_contracts'),
    url(r'^contract/(?P<pk>\d+)/$',
        views.ContractDetail.as_view(),
        name='view_contract'),

    # Invoices
    url(r'invoice/$',
        views.list_invoices,
        name='list_invoices'),
    url(r'invoice/outstanding/$',
        views.list_outstanding_invoices,
        name='list_outstanding_invoices'),
    url(r'invoice/create/$',
        views.create_invoice,
        name='create_invoice'),
    url(r'invoice/(?P<pk>\d+)/$',
        views.InvoiceDetail.as_view(),
        name='view_invoice'),
    url(r'invoice/(?P<pk>\d+)/csv/$',
        views.InvoiceDetailCSV.as_view(),
        name='view_invoice_csv'),
    url(r'invoice/(?P<pk>\d+)/entries/$',
        views.InvoiceEntriesDetail.as_view(),
        name='view_invoice_entries'),
    url(r'invoice/(?P<invoice_id>\d+)/entries/(?P<entry_id>\d+)/remove/$',
        views.delete_invoice_entry,
        name='delete_invoice_entry'),
    url(r'invoice/(?P<pk>\d+)/edit/$',
        views.InvoiceEdit.as_view(),
        name='edit_invoice'),
    url(r'invoice/(?P<pk>\d+)/delete/$',
        views.InvoiceDelete.as_view(),
        name='delete_invoice'),
)
