/*! UIkit 2.14.0 | http://www.getuikit.com | (c) 2014 YOOtheme | MIT License */
(function ($, UI) {

    "use strict";

    UI.component('nav', {

        defaults: {
            "toggle": ">li.@-parent > a[href='#']",
            "lists": ">li.@-parent > ul",
            "multiple": false
        },

        boot: function () {

            // init code
            UI.ready(function (context) {

                UI.$("[data-@-nav]", context).each(function () {
                    var nav = UI.$(this);

                    if (!nav.data("nav")) {
                        var obj = UI.nav(nav, UI.Utils.options(nav.attr("data-@-nav")));
                    }
                });
            });
        },

        init: function () {

            var $this = this;

            this.on("click", this.options.toggle, function (e) {
                e.preventDefault();
                var ele = UI.$(this);
                $this.open(ele.parent()[0] == $this.element[0] ? ele : ele.parent("li"));
            });

            this.find(this.options.lists).each(function () {
                var $ele = UI.$(this),
                    parent = $ele.parent(),
                    active = parent.hasClass("@-active");

                $ele.wrap('<div style="overflow:hidden;height:0;position:relative;"></div>');
                parent.data("list-container", $ele.parent());

                if (active) $this.open(parent, true);
            });

        },

        open: function (li, noanimation) {

            var element = this.element, $li = UI.$(li);

            if (!this.options.multiple) {

                element.children(".@-open").not(li).each(function () {

                    var ele = UI.$(this);

                    if (ele.data("list-container")) {
                        ele.data("list-container").stop().animate({height: 0}, function () {
                            UI.$(this).parent().removeClass("@-open");
                        });
                    }
                });
            }

            $li.toggleClass("@-open");

            if ($li.data("list-container")) {

                if (noanimation) {
                    $li.data('list-container').stop().height($li.hasClass("@-open") ? "auto" : 0);
                } else {
                    $li.data('list-container').stop().animate({
                        height: ($li.hasClass("@-open") ? getHeight($li.data('list-container').find('ul:first')) : 0)
                    });
                }
            }
        }
    });


    // helper

    function getHeight(ele) {
        var $ele = UI.$(ele), height = "auto";

        if ($ele.is(":visible")) {
            height = $ele.outerHeight();
        } else {
            var tmp = {
                position: $ele.css("position"),
                visibility: $ele.css("visibility"),
                display: $ele.css("display")
            };

            height = $ele.css({position: 'absolute', visibility: 'hidden', display: 'block'}).outerHeight();

            $ele.css(tmp); // reset element
        }

        return height;
    }

})(jQuery, UIkit);
