/*! UIkit 2.14.0 | http://www.getuikit.com | (c) 2014 YOOtheme | MIT License */
(function ($, UI) {

    "use strict";

    var scrollpos = {x: window.scrollX, y: window.scrollY},
        $win = UI.$win,
        $doc = UI.$doc,
        $html = UI.$html,
        Offcanvas = {

            show: function (element) {

                element = UI.$(element);

                if (!element.length) return;

                var $body = UI.$('body'),
                    bar = element.find(".@-offcanvas-bar:first"),
                    rtl = (UI.langdirection == "right"),
                    flip = bar.hasClass("@-offcanvas-bar-flip") ? -1 : 1,
                    dir = flip * (rtl ? -1 : 1);

                scrollpos = {x: window.pageXOffset, y: window.pageYOffset};

                element.addClass("@-active");

                $body.css({"width": window.innerWidth, "height": window.innerHeight}).addClass("@-offcanvas-page");
                $body.css((rtl ? "margin-right" : "margin-left"), (rtl ? -1 : 1) * (bar.outerWidth() * dir)).width(); // .width() - force redraw

                $html.css('margin-top', scrollpos.y * -1);

                bar.addClass("@-offcanvas-bar-show");

                this._initElement(element);

                $doc.trigger('show.uk.offcanvas', [element, bar]);
            },

            hide: function (force) {

                var $body = UI.$('body'),
                    panel = UI.$(".@-offcanvas.@-active"),
                    rtl = (UI.langdirection == "right"),
                    bar = panel.find(".@-offcanvas-bar:first"),
                    finalize = function () {
                        $body.removeClass("@-offcanvas-page").css({
                            "width": "",
                            "height": "",
                            "margin-left": "",
                            "margin-right": ""
                        });
                        panel.removeClass("@-active");
                        bar.removeClass("@-offcanvas-bar-show");
                        $html.css('margin-top', '');
                        window.scrollTo(scrollpos.x, scrollpos.y);
                        UI.$doc.trigger('hide.uk.offcanvas', [panel, bar]);
                    };

                if (!panel.length) return;

                if (UI.support.transition && !force) {

                    $body.one(UI.support.transition.end, function () {
                        finalize();
                    }).css((rtl ? "margin-right" : "margin-left"), "");

                    setTimeout(function () {
                        bar.removeClass("@-offcanvas-bar-show");
                    }, 0);

                } else {
                    finalize();
                }
            },

            _initElement: function (element) {

                if (element.data("OffcanvasInit")) return;

                element.on("click.uk.offcanvas swipeRight.uk.offcanvas swipeLeft.uk.offcanvas", function (e) {

                    var target = UI.$(e.target);

                    if (!e.type.match(/swipe/)) {

                        if (!target.hasClass("@-offcanvas-close")) {
                            if (target.hasClass("@-offcanvas-bar")) return;
                            if (target.parents(".@-offcanvas-bar:first").length) return;
                        }
                    }

                    e.stopImmediatePropagation();
                    Offcanvas.hide();
                });

                element.on("click", "a[href^='#']", function (e) {

                    var element = $(this),
                        href = element.attr("href");

                    if (href == "#") {
                        return;
                    }

                    UI.$doc.one('hide.uk.offcanvas', function () {

                        var target = $(href);

                        if (!target.length) {
                            target = UI.$('[name="' + href.replace('#', '') + '"]');
                        }

                        if (UI.Utils.scrollToElement && target.length) {
                            UI.Utils.scrollToElement(target);
                        } else {
                            window.location.href = href;
                        }
                    });

                    Offcanvas.hide();
                });

                element.data("OffcanvasInit", true);
            }
        };

    UI.component('offcanvasTrigger', {

        boot: function () {

            // init code
            $html.on("click.offcanvas.uikit", "[data-@-offcanvas]", function (e) {

                e.preventDefault();

                var ele = UI.$(this);

                if (!ele.data("offcanvasTrigger")) {
                    var obj = UI.offcanvasTrigger(ele, UI.Utils.options(ele.attr("data-@-offcanvas")));
                    ele.trigger("click");
                }
            });

            $html.on('keydown.uk.offcanvas', function (e) {

                if (e.keyCode === 27) { // ESC
                    Offcanvas.hide();
                }
            });
        },

        init: function () {

            var $this = this;

            this.options = $.extend({
                "target": $this.element.is("a") ? $this.element.attr("href") : false
            }, this.options);

            this.on("click", function (e) {
                e.preventDefault();
                Offcanvas.show($this.options.target);
            });
        }
    });

    UI.offcanvas = Offcanvas;

})(jQuery, UIkit);
