/*! UIkit 2.14.0 | http://www.getuikit.com | (c) 2014 YOOtheme | MIT License */
(function ($, UI) {

    "use strict";


    UI.component('tab', {

        defaults: {
            'target': '>li:not(.@-tab-responsive, .@-disabled)',
            'connect': false,
            'active': 0,
            'animation': false,
            'duration': 200
        },

        boot: function () {

            // init code
            UI.ready(function (context) {

                UI.$("[data-@-tab]", context).each(function () {

                    var tab = UI.$(this);

                    if (!tab.data("tab")) {
                        var obj = UI.tab(tab, UI.Utils.options(tab.attr("data-@-tab")));
                    }
                });
            });
        },

        init: function () {

            var $this = this;

            this.on("click", this.options.target, function (e) {
                e.preventDefault();
                $this.find($this.options.target).not(this).removeClass(UI.prefix("@-active")).blur();
                $this.trigger("change.uk.tab", [UI.$(this).addClass("@-active")]);
            });

            if (this.options.connect) {
                this.connect = $(this.options.connect);
            }

            // init responsive tab
            this.responsivetab = UI.$('<li class="@-tab-responsive @-active"><a></a></li>').append(UI.prefix('<div class="@-dropdown @-dropdown-small"><ul class="@-nav @-nav-dropdown"></ul><div>'));

            this.responsivetab.dropdown = this.responsivetab.find('.@-dropdown');
            this.responsivetab.lst = this.responsivetab.dropdown.find('ul');
            this.responsivetab.caption = this.responsivetab.find('a:first');

            if (this.element.hasClass("@-tab-bottom")) this.responsivetab.dropdown.addClass("@-dropdown-up");

            // handle click
            this.responsivetab.lst.on('click', 'a', function (e) {

                e.preventDefault();
                e.stopPropagation();

                var link = $(this);

                $this.element.children(':not(.@-tab-responsive)').eq(link.data('index')).trigger('click');
            });

            this.on('show.uk.switcher change.uk.tab', function (e, tab) {
                $this.responsivetab.caption.html(tab.text());
            });

            this.element.append(this.responsivetab);

            // init UIkit components
            if (this.options.connect) {
                UI.switcher(this.element, {
                    "toggle": ">li:not(.@-tab-responsive)",
                    "connect": this.options.connect,
                    "active": this.options.active,
                    "animation": this.options.animation,
                    "duration": this.options.duration
                });
            }

            UI.dropdown(this.responsivetab, {"mode": "click"});

            // init
            $this.trigger("change.uk.tab", [this.element.find(this.options.target).filter('.@-active')]);

            this.check();

            UI.$win.on('resize orientationchange', UI.Utils.debounce(function () {
                if ($this.element.is(":visible"))  $this.check();
            }, 100));

            this.on('display.uk.check', function () {
                if ($this.element.is(":visible"))  $this.check();
            });
        },

        check: function () {

            var children = this.element.children(':not(.@-tab-responsive)').removeClass('@-hidden');

            if (!children.length) return;

            var top = (children.eq(0).offset().top + Math.ceil(children.eq(0).height() / 2)),
                doresponsive = false,
                item, link;

            this.responsivetab.lst.empty();

            children.each(function () {

                if ($(this).offset().top > top) {
                    doresponsive = true;
                }
            });

            if (doresponsive) {

                for (var i = 0; i < children.length; i++) {

                    item = UI.$(children.eq(i));
                    link = item.find('a');

                    if (item.css('float') != 'none' && !item.attr('@-dropdown')) {

                        item.addClass('@-hidden');

                        if (!item.hasClass('@-disabled')) {
                            this.responsivetab.lst.append('<li><a href="' + link.attr('href') + '" data-index="' + i + '">' + link.html() + '</a></li>');
                        }
                    }
                }
            }

            this.responsivetab[this.responsivetab.lst.children().length ? 'removeClass' : 'addClass']('@-hidden');
        }
    });

})(jQuery, UIkit);
