from upload_to import format_filename
from mock import Mock


def test_complete_rename():
    upload_to = format_filename('path/to/my/file.jpg')
    filename = upload_to(object(), 'old_filename.jpg')
    assert filename == 'path/to/my/file.jpg'


def test_instance_attr_replace():
    mock = Mock()
    mock.first_name = 'Chris'
    mock.last_name = 'McKenzie'
    upload_to = format_filename('path/to/my/{first_name}_{last_name}.jpg')
    filename = upload_to(mock, 'old_filename.jpg')
    assert filename == 'path/to/my/Chris_McKenzie.jpg'
    upload_to = format_filename('path/to/my/{first_name}_{last_name}')
    filename = upload_to(mock, 'old_filename.jpg')
    assert filename == 'path/to/my/Chris_McKenzie.jpg'


def test_filename():
    upload_to = format_filename('path/to/my/{__filename}.jpg', False)
    filename = upload_to(object(), 'old_filename.png')
    assert filename == 'path/to/my/old_filename.jpg'


def test_extension():
    upload_to = format_filename('path/to/my/newname{__ext}', False)
    filename = upload_to(object(), 'old_filename.png')
    assert filename == 'path/to/my/newname.png'
