import os
from setuptools import setup, find_packages
import user_media


def read(fname):
    try:
        return open(os.path.join(os.path.dirname(__file__), fname)).read()
    except IOError:
        return ''


setup(
    name="django-user-media",
    version=user_media.__version__,
    description=read('DESCRIPTION'),
    long_description=read('README.rst'),
    license='The MIT License',
    platforms=['OS Independent'],
    keywords='django, common, reusable, media, files, upload',
    author='Martin Brochhaus',
    author_email='mbrochh@gmail.com',
    url="https://github.com/bitmazk/django-user-media",
    packages=find_packages(),
    include_package_data=True,
    install_requires=[
        'django',
        'django-generic-positions',
        'simplejson',
    ],
)
