#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2009 Éric Veiras Galisson.
# 
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 2 of the License, or
#  (at your option) any later version.
# 
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see http://www.gnu.org/licenses/.
#
from django.db import models
from django.contrib.auth.models import User
from userthemes.config import DEFAULT_THEME, THEMES_CHOICE


class UserTheme(models.Model):
    """
    A simple user theme implementation which extends the django.contrib.auth.User
    For the moment, it doesn't support other authentication backends.
    
    Fields
    * user which points to a user id
    * theme which stores a string representing the name of the chosen theme in a list generated by the config module
    """
    user = models.OneToOneField(User)
    theme = models.CharField(max_length=20, choices=THEMES_CHOICE, blank=False)

