import inspect
from django.conf import settings
from django.utils import importlib

from widgets import UIWidget
from exceptions import DuplicateWidget, WidgetNotFound

available_widgets = {}

def load_widgets():
    for app in settings.INSTALLED_APPS:
        if app == 'django_widgets':
            continue

        try:
            module = importlib.import_module(app)
        except ImportError:
            warnings.ward("Could not import app: %s" % app)

        try:
            widgets_module = importlib.import_module("%s.widgets" % app)
        except ImportError:
            continue

        for widget_name, widget in inspect.getmembers(widgets_module, inspect.isclass):
            if widget_name in available_widgets:
                raise DuplicateWidget()

            if issubclass(widget, UIWidget):
                available_widgets[widget_name] = widget


def get_widget(name):
    if name in available_widgets:
        return available_widgets[name]()
    else:
        raise WidgetNotFound()
