from django.template.loader import render_to_string
from django.template import TemplateDoesNotExist


class UIWidget(object):
    def __init__(self):
        pass

    def render(self, **kwargs):
        raise NotImplementedError()



class TemplateWidget(UIWidget):
    template_name = None
    context = None

    def __init__(self):
        super(TemplateWidget, self).__init__()

    def render(self, **kwargs):
        context = self.get_context_data()

        if not self.template_name:
            raise TemplateDoesNotExist('Template name cannot be None')

        return render_to_string(self.template_name, kwargs, context_instance=context)

    def get_context_data(self):
        return self.context

