from django import template
from ..utils import load_widgets, get_widget

register = template.Library()

load_widgets()


class WidgetNode(template.Node):
    def __init__(self, widget_name, **kwargs):
        self.widget_name = widget_name
        self.widget_args = kwargs

    def render(self, context):
        widget = get_widget(self.widget_name)
        widget.context = context
        return widget.render(**self.widget_args)


@register.tag
def widget(parser, token):
    arguments = token.split_contents()
    # extract widget name
    widget_name = arguments[1].strip("\"'")

    # remove the first two arguments
    arguments = arguments[2:]

    widget_args = {}
    # format arguments to dict
    for argument in arguments:
        name, value = argument.split("=")
        value = value.strip("\"''")

        widget_args[name] = value

    return WidgetNode(widget_name, **widget_args)
