django-widgets
==============

A library to support creating reusable UI widgets for Django. 

Django-widgets uses Django's template tags for implementing widgets. However, it tries to simplify the way we create widgets through template tags by providing generic classes which you can use to start developing your UI widgets rather than worrying about the setup of template tags.


Usage
=====
Install django-widgets:

	pip install django-widgets
	
Add 'django_widgets' to your INSTALLED_APPS. 

Django widgets will be looking for a module called 'widgets' in your root app directory. Make sure you add your widgets to that module.

Then create your own widgets by subclassing Widget and TemplateWidget available under 'django_widgets.widgets'

* 'Widget' is the base class which all other widgets depend upon. Subclassing this one gives you the flexibility to basically do anything before returning the output. All you have to do is override the render method and do your magic.

* 'TemplateWidget' is a more specialized version of 'Widget', which lets you specify the template name and it'll render this template for you. Override get_context_data just like you do with Django's Class-based views to return the template context and you're done.

The example project contains the following samples. It creates two widgets based on the two base classes described above.


**Your widgets.py:**

	from django_widgets.widgets import Widget, TemplateWidget


	class HelloWidget(Widget):
		def render(self, **kwargs):
			return 'Hello world'


	class HelloTemplateWidget(TemplateWidget):
		template_name = 'template.html'

		def get_context_data(self):
			context = super(HelloTemplateWidget, self).get_context_data()

			context['some_var'] = 123

			return context

**Your HTML:**
	
	{% load widget %}
	<html>
		<body>
			{% widget 'HelloWidget' arg1="Hello" arg2="World" %}
			<br />

			{% widget 'HelloTemplateWidget' sentence="Hello World" %}
		</body>
	</html>

**template.html:**
	
	<html>
		<body>
			Template widget args "{{ sentence }}" and context value is {{ some_var }}
		</body>
	</html>


Caching
=======

Django has [built-in caching for template tags](https://docs.djangoproject.com/en/dev/topics/cache/#template-fragment-caching) and they can also be used with django widgets.

	{% load cache %}
	{% cache 500 sidebar %}
		{% widget 'HelloWidget' arg1="Hello" arg2="World" %}
	{% endcache %}

Contributions
=============

If you like this project, you can contribute by submitting a pull request with modifications. All contributions are welcome and much appreciated.