MODULE_INFO = {
    'animation': {'path': 'animation/animation-min.js',
                 'requires': ['dom', 'event'],
                 'type': 'js'},
    'autocomplete': {'optional': ['connection', 'animation'],
                    'path': 'autocomplete/autocomplete-min.js',
                    'requires': ['dom', 'event', 'datasource'],
                    'skinnable': True,
                    'type': 'js'},
    'base': {'after': ['reset', 'fonts', 'grids'],
            'path': 'base/base-min.css',
            'type': 'css'},
    'button': {'optional': ['menu'],
              'path': 'button/button-min.js',
              'requires': ['element'],
              'skinnable': True,
              'type': 'js'},
    'calendar': {'path': 'calendar/calendar-min.js',
                'requires': ['event', 'dom'],
                'skinnable': True,
                'type': 'js'},
    'carousel': {'optional': ['animation'],
                'path': 'carousel/carousel-min.js',
                'requires': ['element'],
                'skinnable': True,
                'type': 'js'},
    'charts': {'path': 'charts/charts-min.js',
              'requires': ['element', 'json', 'datasource'],
              'type': 'js'},
    'colorpicker': {'optional': ['animation'],
                   'path': 'colorpicker/colorpicker-min.js',
                   'requires': ['slider', 'element'],
                   'skinnable': True,
                   'type': 'js'},
    'connection': {'path': 'connection/connection-min.js',
                  'requires': ['event'],
                  'type': 'js'},
    'container': {'optional': ['dragdrop', 'animation', 'connection'],
                 'path': 'container/container-min.js',
                 'requires': ['dom', 'event'],
                 'skinnable': True,
                 'supersedes': ['containercore'],
                 'type': 'js'},
    'containercore': {'path': 'container/container_core-min.js',
                     'pkg': 'container',
                     'requires': ['dom', 'event'],
                     'type': 'js'},
    'cookie': {'path': 'cookie/cookie-min.js',
              'requires': ['yahoo'],
              'type': 'js'},
    'datasource': {'optional': ['connection'],
                  'path': 'datasource/datasource-min.js',
                  'requires': ['event'],
                  'type': 'js'},
    'datatable': {'optional': ['calendar', 'dragdrop', 'paginator'],
                 'path': 'datatable/datatable-min.js',
                 'requires': ['element', 'datasource'],
                 'skinnable': True,
                 'type': 'js'},
    'dom': {'path': 'dom/dom-min.js', 'requires': ['yahoo'], 'type': 'js'},
    'dragdrop': {'path': 'dragdrop/dragdrop-min.js',
                'requires': ['dom', 'event'],
                'type': 'js'},
    'editor': {'optional': ['animation', 'dragdrop'],
              'path': 'editor/editor-min.js',
              'requires': ['menu', 'element', 'button'],
              'skinnable': True,
              'supersedes': ['simpleeditor'],
              'type': 'js'},
    'element': {'path': 'element/element-min.js',
               'requires': ['dom', 'event'],
               'type': 'js'},
    'event': {'path': 'event/event-min.js', 'requires': ['yahoo'], 'type': 'js'},
    'fonts': {'path': 'fonts/fonts-min.css', 'type': 'css'},
    'get': {'path': 'get/get-min.js', 'requires': ['yahoo'], 'type': 'js'},
    'grids': {'optional': ['reset'],
             'path': 'grids/grids-min.css',
             'requires': ['fonts'],
             'type': 'css'},
    'history': {'path': 'history/history-min.js',
               'requires': ['event'],
               'type': 'js'},
    'imagecropper': {'path': 'imagecropper/imagecropper-min.js',
                    'requires': ['dom', 'event', 'dragdrop', 'element', 'resize'],
                    'skinnable': True,
                    'type': 'js'},
    'imageloader': {'path': 'imageloader/imageloader-min.js',
                   'requires': ['event', 'dom'],
                   'type': 'js'},
    'json': {'path': 'json/json-min.js', 'requires': ['yahoo'], 'type': 'js'},
    'layout': {'optional': ['animation', 'dragdrop', 'resize', 'selector'],
              'path': 'layout/layout-min.js',
              'requires': ['dom', 'event', 'element'],
              'skinnable': True,
              'type': 'js'},
    'logger': {'optional': ['dragdrop'],
              'path': 'logger/logger-min.js',
              'requires': ['event', 'dom'],
              'skinnable': True,
              'type': 'js'},
    'menu': {'path': 'menu/menu-min.js',
            'requires': ['containercore'],
            'skinnable': True,
            'type': 'js'},
    'paginator': {'path': 'paginator/paginator-min.js',
                 'requires': ['element'],
                 'skinnable': True,
                 'type': 'js'},
    'profiler': {'path': 'profiler/profiler-min.js',
                'requires': ['yahoo'],
                'type': 'js'},
    'profilerviewer': {'path': 'profilerviewer/profilerviewer-min.js',
                      'requires': ['profiler', 'yuiloader', 'element'],
                      'skinnable': True,
                      'type': 'js'},
    'reset': {'path': 'reset/reset-min.css', 'type': 'css'},
    'reset-fonts': {'path': 'reset-fonts/reset-fonts.css',
                   'rollup': 2,
                   'supersedes': ['reset', 'fonts'],
                   'type': 'css'},
    'reset-fonts-grids': {'path': 'reset-fonts-grids/reset-fonts-grids.css',
                         'rollup': 4,
                         'supersedes': ['reset', 'fonts', 'grids', 'reset-fonts'],
                         'type': 'css'},
    'resize': {'optional': ['animation'],
              'path': 'resize/resize-min.js',
              'requires': ['dom', 'event', 'dragdrop', 'element'],
              'skinnable': True,
              'type': 'js'},
    'selector': {'path': 'selector/selector-min.js',
                'requires': ['yahoo', 'dom'],
                'type': 'js'},
    'simpleeditor': {'optional': ['containercore',
                                'menu',
                                'button',
                                'animation',
                                'dragdrop'],
                    'path': 'editor/simpleeditor-min.js',
                    'pkg': 'editor',
                    'requires': ['element'],
                    'skinnable': True,
                    'type': 'js'},
    'slider': {'optional': ['animation'],
              'path': 'slider/slider-min.js',
              'requires': ['dragdrop'],
              'skinnable': True,
              'type': 'js'},
    'stylesheet': {'path': 'stylesheet/stylesheet-min.js',
                  'requires': ['yahoo'],
                  'type': 'js'},
    'tabview': {'optional': ['connection'],
               'path': 'tabview/tabview-min.js',
               'requires': ['element'],
               'skinnable': True,
               'type': 'js'},
    'treeview': {'optional': ['json'],
                'path': 'treeview/treeview-min.js',
                'requires': ['event', 'dom'],
                'skinnable': True,
                'type': 'js'},
    'uploader': {'path': 'uploader/uploader.js',
                'requires': ['element'],
                'type': 'js'},
    'utilities': {'path': 'utilities/utilities.js',
                 'rollup': 8,
                 'supersedes': ['yahoo',
                               'event',
                               'dragdrop',
                               'animation',
                               'dom',
                               'connection',
                               'element',
                               'yahoo-dom-event',
                               'get',
                               'yuiloader',
                               'yuiloader-dom-event'],
                 'type': 'js'},
    'yahoo': {'path': 'yahoo/yahoo-min.js', 'type': 'js'},
    'yahoo-dom-event': {'path': 'yahoo-dom-event/yahoo-dom-event.js',
                       'rollup': 3,
                       'supersedes': ['yahoo', 'event', 'dom'],
                       'type': 'js'},
    'yuiloader': {'path': 'yuiloader/yuiloader-min.js',
                 'supersedes': ['yahoo', 'get'],
                 'type': 'js'},
    'yuiloader-dom-event': {'path': 'yuiloader-dom-event/yuiloader-dom-event.js',
                           'rollup': 5,
                           'supersedes': ['yahoo',
                                         'dom',
                                         'event',
                                         'get',
                                         'yuiloader',
                                         'yahoo-dom-event'],
                           'type': 'js'},
    'yuitest': {'path': 'yuitest/yuitest-min.js',
               'requires': ['logger'],
               'skinnable': True,
               'type': 'js'}}

SKIN = {
    'after': ['reset', 'fonts', 'grids', 'base'],
    'base': 'assets/skins/',
    'defaultSkin': 'sam',
    'path': 'skin.css',
    'rollup': 3}

MODULE_INFO[SKIN['defaultSkin']] = {
    'type': 'css',
    'path': SKIN['base'] + SKIN['defaultSkin'] + '/' + SKIN['path'],
    'after': SKIN['after'] }
