from imaplib import IMAP4_SSL
from django.contrib.auth.models import User
from django.core.exceptions import ValidationError
from settings import IMAP_AUTH_HOST, IMAP_AUTH_ADMIN, IMAP_AUTH_ALLOWED_USERS, IMAP_DOMAIN


class IMAPBackend(object):

    def authenticate(self, username=None, password=None):

        if IMAP_DOMAIN and IMAP_DOMAIN not in username:
            raise ValidationError('Domain not allowed.')

        try:
            conn = IMAP4_SSL(IMAP_AUTH_HOST)
        except Exception:
            raise ValidationError("Can't connect to remote host.")

        try:
            conn.login(username, password)
            conn.logout()
        except Exception:
            raise ValidationError("Invalid credentials.")

        try:
            user = User.objects.get(username=username)
            return user
        except User.DoesNotExist:
            if username in IMAP_AUTH_ALLOWED_USERS or IMAP_AUTH_ALLOWED_USERS == ['*'] or username in IMAP_AUTH_ADMIN:
                password = User.objects.make_random_password()
                user = User.objects.create_user(username, password=password)
                if username in IMAP_AUTH_ADMIN:
                    user.is_superuser = True
                    user.is_staff = True
                user.save()
                return user

        return None

    def get_user(self, user_id):
        try:
            return User.objects.get(pk=user_id)
        except User.DoesNotExist:
            return None