from django.conf import settings
from django.core.exceptions import ImproperlyConfigured


# Hostname of imap server used to authenticate. If this imap server is used by
# other domains you should set the option IMAP_DOMAIN
IMAP_AUTH_HOST = getattr(settings, 'IMAP_AUTH_HOST', None)


# This option specify which domain should be able to log-in. Since sometimes
# the same imap server is used for different domains - ie. google apps -
# You should specify here your domain to prevent access from users from other
# domains.
IMAP_DOMAIN = getattr(settings, 'IMAP_DOMAIN', None)


# This list contain the emails that will be created with admin flag.
# These users will be able to log-in at admin interface and manage other users.
IMAP_AUTH_ADMIN = getattr(settings, 'IMAP_AUTH_ADMIN', None)


# This list contain the emails allowed to log-in, this is useful in apps where
# access are limited to a corporation, or a small number of users.
# if set ['*'], anyone will be able to log-in
IMAP_AUTH_ALLOWED_USERS = getattr(settings, 'IMAP_AUTH_ALLOWED_USERS', None)


if IMAP_AUTH_HOST is None:
    raise ImproperlyConfigured("Missing IMAP_AUTH_HOST in settings.py")

if IMAP_AUTH_ADMIN is None:
    raise ImproperlyConfigured("Missing IMAP_AUTH_ADMIN in settings.py")

if IMAP_AUTH_ALLOWED_USERS is None:
    raise ImproperlyConfigured("Missing IMAP_AUTH_ALLOWED_USERS in settings.py")