#!/usr/bin/python
"""This is the overall settings module for a single Backstage Project instance
 It will import settings from the Backstage package, and may over-ride them.
 In turn, each Backstage Site instance will import these settings, and may over-ride them."""
#
#
#### DO NOT EDIT THIS FILE ####
#
#
import os
import sys

#Assume that 'manage.py' and 'settings.py' are siblings at the root of the Backstage Project instance
PROJECT_ROOT = os.path.dirname(os.path.abspath(__file__))
PROJECT_PATH, PROJECT_DIRNAME = os.path.split(PROJECT_ROOT)
PROJECT_NAME = PROJECT_DIRNAME
ROOT_URLCONF = "%s.project.urls" % PROJECT_NAME

PROJECT_NAME in sys.path or sys.path.append(PROJECT_NAME)
PROJECT_PATH in sys.path or sys.path.append(PROJECT_PATH)

#Here, we import all the backstage default settings, django default settings, etc...
from backstage.settings.settings import *

###Here, we extend and over-ride them....

#Extend INSTALLED_APPS
INSTALLED_APPS = list(INSTALLED_APPS)
PROJECT_NAME in INSTALLED_APPS or INSTALLED_APPS.insert(0,PROJECT_NAME)
project_app = '%s.project' % PROJECT_NAME
project_app in INSTALLED_APPS or INSTALLED_APPS.insert(1,project_app)

#Import everything from local.settings
exec('from %s.local.settings import *' % PROJECT_NAME)