ALLOWED_HOSTS = []

CACHES = {
    'default': {
        'BACKEND': 'django.core.cache.backends.dummy.DummyCache',
    }
}

SECRET_KEY=''

TEMPLATE_DIRS = []
TEMPLATE_LOADERS = [
    'django.template.loaders.filesystem.Loader',
    'django.template.loaders.app_directories.Loader',
]

MIDDLEWARE_CLASSES = [
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',   
    'django.middleware.common.CommonMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'debug_toolbar.middleware.DebugToolbarMiddleware',
]

TEMPLATE_CONTEXT_PROCESSORS = [
    'django.contrib.auth.context_processors.auth',
    'django.contrib.messages.context_processors.messages',
    'django.core.context_processors.debug',
    'django.core.context_processors.i18n',
    'django.core.context_processors.media',
    'django.core.context_processors.static',
    'django.core.context_processors.request',
    'django.core.context_processors.tz',
    'sekizai.context_processors.sekizai',
    ]

STATICFILES_FINDERS = ["django.contrib.staticfiles.finders.FileSystemFinder",
 "django.contrib.staticfiles.finders.AppDirectoriesFinder",
 "compressor.finders.CompressorFinder",]

AUTHENTICATION_BACKENDS =  [ 'django.contrib.auth.backends.ModelBackend',]

try:
    DEBUG_TOOLBAR_CONFIG['INTERCEPT_REDIRECTS'] = False
except:
    DEBUG_TOOLBAR_CONFIG = {}
    DEBUG_TOOLBAR_CONFIG['INTERCEPT_REDIRECTS'] = False

