#!/usr/bin/python
"""This is the overall settings module for a single Backstage venue instance
 It will import settings from the Backstage package, and may over-ride them.
 In turn, each Backstage Site instance will import these settings, and may over-ride them."""
#
#
#### DO NOT EDIT THIS FILE ####
#
#
import os
import sys

#Assume that 'manage.py' and 'settings.py' are siblings at the root of the Backstage venue instance
VENUE_ROOT = os.path.dirname(os.path.abspath(__file__))
VENUE_PATH, VENUE_DIRNAME = os.path.split(VENUE_ROOT)
VENUE_NAME = VENUE_DIRNAME
ROOT_URLCONF = "%s.venue.urls" % VENUE_NAME

VENUE_NAME in sys.path or sys.path.append(VENUE_NAME)
VENUE_PATH in sys.path or sys.path.append(VENUE_PATH)

#Here, we import all the backstage default settings, django default settings, etc...
from backstage.settings.settings import *

###Here, we extend and over-ride them....

#Extend INSTALLED_APPS
INSTALLED_APPS = list(INSTALLED_APPS)
VENUE_NAME in INSTALLED_APPS or INSTALLED_APPS.insert(0, VENUE_NAME)
venue_app = '%s.venue' % VENUE_NAME
venue_app in INSTALLED_APPS or INSTALLED_APPS.insert(1, venue_app)
#local_app = '%s.local' % venue_app
#local_app in INSTALLED_APPS or INSTALLED_APPS.insert(2, local_app)

#Import everything from local.settings
exec('from %s.local.settings import *' % VENUE_NAME)
