from django.core.management.base import BaseCommand
from django.core.management.base import CommandError
from django.conf import settings
from os.path import abspath
from optparse import make_option

class Command(BaseCommand):
    args = ''
    option_list = BaseCommand.option_list + (
        make_option(
            '--port',
            action='store',
            dest='tcp_port',
            default=8099,
            help='The tcp port to use for Nginx to talk to Django.'
            ),
        make_option(
            '--domain',
            action='store',
            dest='domain',
            help='The fully qualified host name the nginx will host match on'
            ),
        )

    help = 'Generates an Nginx config to map the current Django app to Nginx.'


    def handle(self, *args, **options):
        variables = {
            "HOST_ADDRESS": "127.0.0.1",
            "PORT": options["tcp_port"],
            "DOMAIN": options["domain"],
            "STATIC_URL": settings.STATIC_URL,
            "DOCROOT": abspath(settings.STATIC_ROOT),
            }
        config = """# Nginx config generated by django-config

upstream django {
   server localhost:%(PORT)s;
}

server {
listen  %(HOST_ADDRESS)s:80;
server_name %(DOMAIN)s;
root %(DOCROOT)s;

location %(STATIC_URL)s {
   rewrite ^%(STATIC_URL)s(.*)$ /$1 break;
}

location  / {
   proxy_pass http://django;
   proxy_redirect off;
   proxy_set_header Host "%(DOMAIN)s";
   proxy_next_upstream error timeout;
   proxy_connect_timeout 120;
   proxy_send_timeout 120;
   proxy_read_timeout 120;
}

}
""" % variables
        print config

# End



