# 
# Test if a block is defined or not
# Solution by BitKickers :
# http://bitkickers.blogspot.com/2010/10/check-if-block-is-defined-in-django.html
#

from django import template

register = template.Library()

@register.tag(name='captureas')  
def do_captureas(parser, token):  
    try:  
        tag_name, args = token.contents.split(None, 1)  
    except ValueError:  
        raise template.TemplateSyntaxError("'captureas' node requires a variable name.")  
    nodelist = parser.parse(('endcaptureas',))
    parser.delete_first_token()  
    return CaptureasNode(nodelist, args)  
  
class CaptureasNode(template.Node):  
    def __init__(self, nodelist, varname):  
        self.nodelist = nodelist  
        self.varname = varname  
  
    def render(self, context):  
        output = self.nodelist.render(context)  
        context[self.varname] = output  
        return ''  