#coding:utf-8
from django.conf import settings

def language(request):
    lang_domain = []
    host = request.get_host().split('.')
    lang_list = [l for l, t in settings.LANGUAGES]
    for item in settings.LANGUAGES:
        host_clear = host
        if item[0] == settings.LANGUAGE_CODE:
            lang_sub = ''
        else:
            lang_sub = '%s.' % item[0]
        if len(host[0]) == 2 and host[0] in lang_list:
            host_clear = host[1:]
        lang_domain.append((item[0], item[1], '%s://%s%s' % (request.is_secure() and 'https' or 'http', lang_sub , '.'.join(host_clear))))
    if request.LANGUAGE_CODE == 'ar' or request.LANGUAGE_CODE == 'he':
        direction = 'rtl'
    else:
        direction = 'ltr'
    return {'LANGUAGES': lang_domain, 'LANGUAGE_DIRECTION': direction}