#coding: utf-8
from django.conf import settings
from django.utils import translation
from django.http import HttpResponseNotFound

class MultiLanguageMiddleware(object):
    def process_request(self, request):
        lang = request.get_host().split('.')[0]
        if len(lang) == 2:
            if lang not in [l for l, t in settings.LANGUAGES]:
                return HttpResponseNotFound('Not allowed language')
        else:
            lang = settings.LANGUAGE_CODE
            
        translation.activate(lang)
        request.LANGUAGE_CODE = translation.get_language()
        return

    def process_response(self, request, response):
        return response