/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Module;
import com.google.jstestdriver.FailureException;
import com.google.jstestdriver.JsTestDriver;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.PluginLoader;
import com.google.jstestdriver.browser.BrowserPanicException;
import com.google.jstestdriver.config.CmdLineFlags;
import com.google.jstestdriver.config.CmdLineFlagsFactory;
import com.google.jstestdriver.config.ConfigurationException;
import com.google.jstestdriver.config.InvalidFlagException;
import com.google.jstestdriver.config.UnreadableFilesException;
import com.google.jstestdriver.embedded.JsTestDriverBuilder;
import com.google.jstestdriver.guice.TestResultPrintingModule;
import com.google.jstestdriver.util.RetryException;
import java.util.List;
import java.util.logging.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger logger = LoggerFactory.getLogger(JsTestDriver.class);

    public static void main(String[] args) {
        try {
            CmdLineFlags cmdLineFlags = new CmdLineFlagsFactory().create(args);
            List<Plugin> cmdLinePlugins = cmdLineFlags.getPlugins();
            LogManager.getLogManager().readConfiguration(cmdLineFlags.getRunnerMode().getLogConfig());
            PluginLoader pluginLoader = new PluginLoader();
            List<Module> pluginModules = pluginLoader.load(cmdLinePlugins);
            logger.debug("loaded plugins %s", pluginModules);
            JsTestDriverBuilder builder = new JsTestDriverBuilder();
            builder.addBasePaths(cmdLineFlags.getBasePath());
            builder.setConfigurationSource(cmdLineFlags.getConfigurationSource());
            builder.addPluginModules(pluginModules);
            builder.withPluginInitializer(TestResultPrintingModule.TestResultPrintingInitializer.class);
            builder.setRunnerMode(cmdLineFlags.getRunnerMode());
            builder.setFlags(cmdLineFlags.getUnusedFlagsAsArgs());
            JsTestDriver jstd = builder.build();
            jstd.runConfiguration();
            logger.info("Finished action run.");
        }
        catch (InvalidFlagException e) {
            e.printErrorMessages(System.out);
            CmdLineFlags.printUsage(System.out);
            System.exit(1);
        }
        catch (UnreadableFilesException e) {
            System.out.println("Configuration Error: \n" + e.getMessage());
            logger.debug("Details: {}", e);
            System.exit(1);
        }
        catch (ConfigurationException e) {
            System.out.println("Configuration Error: \n" + e.getMessage());
            logger.debug("Details: {}", e);
            System.exit(1);
        }
        catch (RetryException e) {
            System.out.println("Tests failed due to unexpected environment issue: " + e.getCause().getMessage());
            System.exit(1);
        }
        catch (FailureException e) {
            System.out.println("Tests failed: " + e.getMessage());
            System.exit(1);
        }
        catch (BrowserPanicException e) {
            System.out.println("Test run failed due to unresponsive browser: " + e);
            System.exit(1);
        }
        catch (Exception e) {
            logger.debug("Error {}", e);
            e.printStackTrace();
            System.out.println("Unexpected Runner Condition: " + e.getMessage() + "\n Use --runnerMode DEBUG for more information.");
            System.exit(1);
        }
    }
}

