/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.inject.Inject;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import com.google.jstestdriver.server.handlers.pages.Page;
import com.google.jstestdriver.server.handlers.pages.PageType;
import com.google.jstestdriver.server.handlers.pages.SlavePageRequest;
import com.google.jstestdriver.util.HtmlWriter;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SlaveResourceHandler
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(SlaveResourceHandler.class);
    private final Map<PageType, Page> pages;
    private final SlavePageRequest request;
    private final HandlerPathPrefix prefix;
    private final HttpServletResponse response;

    @Inject
    public SlaveResourceHandler(HttpServletResponse response, Map<PageType, Page> pages, SlavePageRequest request, HandlerPathPrefix prefix) {
        this.response = response;
        this.pages = pages;
        this.request = request;
        this.prefix = prefix;
    }

    @Override
    public void handleIt() throws IOException {
        logger.debug("Handling " + this.request);
        HtmlWriter writer = new HtmlWriter(this.response.getWriter(), this.prefix);
        this.request.writeDTD(writer);
        this.pages.get((Object)this.request.getPageType()).render(writer, this.request);
    }
}

