/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.gson.JsonArray;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.ActionFactory;
import com.google.jstestdriver.BrowserStartupAction;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.FailureCheckerAction;
import com.google.jstestdriver.ServerShutdownAction;
import com.google.jstestdriver.ServerStartupAction;
import com.google.jstestdriver.action.ConfigureGatewayAction;
import com.google.jstestdriver.action.UploadAction;
import com.google.jstestdriver.browser.BrowserActionExecutorAction;
import com.google.jstestdriver.output.PrintXmlTestResultsAction;
import com.google.jstestdriver.output.XmlPrinter;
import com.google.jstestdriver.server.JstdTestCaseStore;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionSequenceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ActionSequenceBuilder.class);
    private final ActionFactory actionFactory;
    private final CapturedBrowsers capturedBrowsers;
    private int localServerPort = -1;
    private int localServerSslPort = -1;
    private boolean reset;
    private List<String> tests = new LinkedList<String>();
    private List<String> dryRunFor = new LinkedList<String>();
    private List<String> commands = new LinkedList<String>();
    private XmlPrinter xmlPrinter;
    private final BrowserActionExecutorAction browserActionsRunner;
    private final FailureCheckerAction failureCheckerAction;
    private final UploadAction uploadAction;
    private final ConfigureGatewayAction.Factory gatewayActionFactory;
    private boolean raiseOnFailure = false;
    private JsonArray gatewayConfig;
    private final BrowserStartupAction browserStartup;
    private final JstdTestCaseStore testCaseStore;

    @Inject
    public ActionSequenceBuilder(ActionFactory actionFactory, BrowserActionExecutorAction browserActionsRunner, FailureCheckerAction failureCheckerAction, UploadAction uploadAction, CapturedBrowsers capturedBrowsers, @Named(value="gateway") JsonArray gatewayConfig, ConfigureGatewayAction.Factory gatewayActionFactory, BrowserStartupAction browserStartup, JstdTestCaseStore testCaseStore) {
        this.actionFactory = actionFactory;
        this.browserActionsRunner = browserActionsRunner;
        this.failureCheckerAction = failureCheckerAction;
        this.uploadAction = uploadAction;
        this.capturedBrowsers = capturedBrowsers;
        this.gatewayConfig = gatewayConfig;
        this.gatewayActionFactory = gatewayActionFactory;
        this.browserStartup = browserStartup;
        this.testCaseStore = testCaseStore;
    }

    private void addServerActions(List<Action> actions, boolean leaveServerRunning) {
        ServerStartupAction serverStartupAction = this.actionFactory.getServerStartupAction(this.localServerPort, this.localServerSslPort, this.capturedBrowsers, this.testCaseStore);
        actions.add(0, serverStartupAction);
        if (!leaveServerRunning) {
            actions.add(new ServerShutdownAction(serverStartupAction));
        } else {
            actions.add(this.browserStartup);
        }
    }

    public ActionSequenceBuilder addTests(List<String> tests) {
        this.tests.addAll(tests);
        return this;
    }

    public ActionSequenceBuilder asDryRunFor(List<String> dryRunFor) {
        this.dryRunFor.addAll(dryRunFor);
        return this;
    }

    public List<Action> build() {
        LinkedList<Action> actions = new LinkedList<Action>();
        actions.add(this.gatewayActionFactory.create(this.gatewayConfig));
        actions.add(this.uploadAction);
        if (!this.leaveServerRunning()) {
            actions.add(this.browserActionsRunner);
        }
        if (this.xmlPrinter != null) {
            actions.add(new PrintXmlTestResultsAction(this.xmlPrinter));
        }
        if (this.needToStartServer()) {
            this.addServerActions(actions, this.leaveServerRunning());
        }
        if (!this.tests.isEmpty() && this.raiseOnFailure) {
            actions.add(this.failureCheckerAction);
        }
        return actions;
    }

    private boolean leaveServerRunning() {
        return this.tests.isEmpty() && this.commands.isEmpty() && !this.reset && this.dryRunFor.isEmpty();
    }

    private boolean needToStartServer() {
        return this.localServerPort != -1;
    }

    public ActionSequenceBuilder reset(boolean reset) {
        this.reset = reset;
        return this;
    }

    public ActionSequenceBuilder withLocalServerPort(int localServerPort) {
        this.localServerPort = localServerPort;
        return this;
    }

    public ActionSequenceBuilder withLocalServerSslPort(int localServerSslPort) {
        this.localServerSslPort = localServerSslPort;
        return this;
    }

    public ActionSequenceBuilder addCommands(List<String> commands) {
        this.commands.addAll(commands);
        return this;
    }

    public ActionSequenceBuilder printingResultsWhenFinished(XmlPrinter printer) {
        this.xmlPrinter = printer;
        return this;
    }

    public ActionSequenceBuilder raiseOnFailure() {
        this.raiseOnFailure = true;
        return this;
    }
}

