/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.google.jstestdriver.protocol.BrowserLog;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BrowserLoggingHandler
implements RequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(BrowserLoggingHandler.class);
    private final Gson gson = new Gson();
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    @Inject
    public BrowserLoggingHandler(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleIt() throws IOException {
        try {
            Collection logs = (Collection)this.gson.fromJson(this.request.getParameter("logs"), new TypeToken<Collection<BrowserLog>>(){}.getType());
            block12: for (BrowserLog log : logs) {
                Logger browserLogger = LoggerFactory.getLogger(log.getSource());
                String message = this.gson.fromJson(log.getMessage(), String.class);
                switch (log.getLevel()) {
                    case 1: {
                        browserLogger.trace(message);
                        continue block12;
                    }
                    case 2: {
                        browserLogger.debug(message);
                        continue block12;
                    }
                    case 3: {
                        browserLogger.info(message);
                        continue block12;
                    }
                    case 4: {
                        browserLogger.warn(message);
                        continue block12;
                    }
                    case 5: {
                        browserLogger.error(message);
                        continue block12;
                    }
                }
                throw new RuntimeException("Unknown logging level:" + log.getLevel());
            }
            this.response.setStatus(200);
        }
        catch (RuntimeException e) {
            this.response.setStatus(500);
            logger.error("Error during BrowserLog write: |" + Arrays.toString(this.request.getParameterValues("logs")) + "|", e);
        }
        finally {
            this.response.getOutputStream().flush();
        }
    }
}

