/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.handlers.pages;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.runner.RunnerType;
import com.google.jstestdriver.server.handlers.pages.PageType;
import com.google.jstestdriver.util.HtmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlavePageRequest {
    public static final String PAGE = "page";
    public static final String ID = "id";
    public static final String MODE = "mode";
    public static final String TIMEOUT = "timeout";
    public static final String UPLOAD_SIZE = "upload_size";
    public static final String LOAD_TYPE = "load_type";
    public static final String TESTCASE_ID = "testcase_id";
    public static final String REFRESH = "refresh";
    private static final Logger logger = LoggerFactory.getLogger(SlavePageRequest.class);
    private final Map<String, String> parameters;
    private final HttpServletRequest request;
    private final HandlerPathPrefix prefix;
    private final CapturedBrowsers browsers;

    public SlavePageRequest(Map<String, String> parameters, HttpServletRequest request, HandlerPathPrefix prefix, CapturedBrowsers browsers) {
        this.parameters = parameters;
        this.request = request;
        this.prefix = prefix;
        this.browsers = browsers;
    }

    public HtmlWriter writeDTD(HtmlWriter writer) throws IOException {
        if ("strict".equals(this.parameters.get(MODE))) {
            writer.writeStrictDtd();
        } else {
            writer.writeQuirksDtd();
        }
        return writer;
    }

    public String createCaptureUrl(RunnerType type) {
        ArrayList<String> urlParts = Lists.newArrayList("/capture");
        this.addParameterToUrlParts(MODE, urlParts);
        this.addParameterToUrlParts(UPLOAD_SIZE, urlParts);
        this.addParameterToUrlParts("rt", urlParts);
        this.addParameterToUrlParts(TESTCASE_ID, urlParts);
        String url = Joiner.on("/").join(urlParts);
        return this.prefix.prefixPath(Joiner.on("/").join(urlParts));
    }

    public String createCaptureUrl() {
        try {
            return this.createCaptureUrl(RunnerType.valueOf(this.parameters.get("rt").toUpperCase()));
        }
        catch (NullPointerException e) {
            logger.error("Invalid/No runner type specified: {} falling back to BROWSER", (Object)this.parameters.get("rt"));
            return this.createCaptureUrl(RunnerType.BROWSER);
        }
    }

    public String createPageUrl(PageType page) {
        ArrayList<String> urlParts = Lists.newArrayList("/slave");
        this.addToUrlParts(PAGE, page.name(), urlParts);
        this.addParameterToUrlParts(ID, urlParts);
        this.addParameterToUrlParts(MODE, urlParts);
        this.addParameterToUrlParts(UPLOAD_SIZE, urlParts);
        this.addParameterToUrlParts(TESTCASE_ID, urlParts);
        String url = Joiner.on("/").join(urlParts);
        logger.trace("creating new url: {} for {}", (Object)url, (Object)page);
        return this.prefix.prefixPath(url);
    }

    private void addParameterToUrlParts(String key, List<String> urlParts) {
        this.addToUrlParts(key, this.parameters.get(key), urlParts);
    }

    private void addToUrlParts(String key, String value, List<String> urlParts) {
        if (value == null || value.isEmpty()) {
            return;
        }
        urlParts.add(key);
        urlParts.add(value);
    }

    public SlaveBrowser getBrowser() {
        String id = this.parameters.get(ID);
        if (id == null) {
            return null;
        }
        return this.browsers.getBrowser(id);
    }

    public PageType getPageType() {
        return PageType.valueOf(this.parameters.get(PAGE).toUpperCase());
    }

    public String getUserAgent() {
        return this.request.getHeader("User-Agent");
    }

    public String getTestCaseId() {
        return this.getParameter(TESTCASE_ID);
    }

    public String toString() {
        return "SlavePageRequest [parameters=" + this.parameters + "]";
    }

    public String getParameter(String key) {
        return this.parameters.get(key);
    }
}

