/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.requesthandlers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Inject;
import com.google.jstestdriver.requesthandlers.HttpMethod;
import com.google.jstestdriver.requesthandlers.NullRequestHandler;
import com.google.jstestdriver.requesthandlers.RequestHandler;
import com.google.jstestdriver.requesthandlers.RequestMatcher;
import com.google.jstestdriver.server.gateway.GatewayRequestHandler;
import com.google.jstestdriver.server.gateway.MockRequestHandler;
import com.google.jstestdriver.server.gateway.MockResponse;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatewayConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(GatewayConfiguration.class);
    public static final String MATCHER = "matcher";
    public static final String SERVER = "server";
    private final GatewayRequestHandler.Factory gatewayFactory;
    private final MockRequestHandler.Factory mockFactory;
    private JsonArray gatewayConfig = new JsonArray();
    private List<RequestMatcher> matchers;
    private Map<RequestMatcher, MockResponse> mockResponses;
    private Map<RequestMatcher, String> destinations;

    @Inject
    public GatewayConfiguration(GatewayRequestHandler.Factory gatewayFactory, MockRequestHandler.Factory mockFactory) {
        this.gatewayFactory = gatewayFactory;
        this.mockFactory = mockFactory;
        this.clearConfiguration();
    }

    public synchronized List<RequestMatcher> getMatchers() {
        return this.matchers;
    }

    public synchronized RequestHandler getRequestHandler(RequestMatcher matcher) {
        MockResponse mockResponse = this.mockResponses.get(matcher);
        if (mockResponse != null) {
            return this.mockFactory.create(mockResponse);
        }
        String destination = this.destinations.get(matcher);
        if (destination != null) {
            return this.gatewayFactory.create(destination, matcher.getPrefix());
        }
        return new NullRequestHandler();
    }

    public synchronized JsonArray getGatewayConfig() {
        return this.gatewayConfig;
    }

    public synchronized void updateConfiguration(JsonArray configuration) throws ServletException {
        this.gatewayConfig = configuration;
        ImmutableList.Builder<RequestMatcher> matchersBuilder = ImmutableList.builder();
        ImmutableMap.Builder<RequestMatcher, MockResponse> mockResponsesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder<RequestMatcher, String> destinationsBuilder = ImmutableMap.builder();
        for (JsonElement element : configuration) {
            JsonObject entry = element.getAsJsonObject();
            RequestMatcher matcher = new RequestMatcher(HttpMethod.ANY, entry.get(MATCHER).getAsString());
            matchersBuilder.add(matcher);
            if (MockResponse.entryDescribesMockResponse(entry)) {
                mockResponsesBuilder.put(matcher, MockResponse.buildFromEntry(entry));
                continue;
            }
            destinationsBuilder.put(matcher, entry.get(SERVER).getAsString());
        }
        this.matchers = matchersBuilder.build();
        this.mockResponses = mockResponsesBuilder.build();
        this.destinations = destinationsBuilder.build();
    }

    public synchronized void clearConfiguration() {
        this.matchers = ImmutableList.of();
        this.mockResponses = ImmutableMap.of();
        this.destinations = ImmutableMap.of();
    }
}

