/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.config;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.browser.DocType;
import com.google.jstestdriver.browser.DocTypeParser;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.config.ConfigurationParser;
import com.google.jstestdriver.config.ParsedConfiguration;
import com.google.jstestdriver.model.BasePaths;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jvyaml.YAML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlParser
implements ConfigurationParser {
    private DocTypeParser docTypeParser = new DocTypeParser();

    @Override
    public Configuration parse(Reader configReader, BasePaths defaultBasePaths) {
        Map data = (Map)YAML.load(configReader);
        LinkedHashSet<FileInfo> resolvedFilesLoad = new LinkedHashSet<FileInfo>();
        LinkedHashSet<FileInfo> testFiles = new LinkedHashSet<FileInfo>();
        LinkedHashSet<FileInfo> resolvedFilesExclude = new LinkedHashSet<FileInfo>();
        String server = "";
        DocType doctype = this.docTypeParser.parse("quirks");
        BasePaths basePaths = defaultBasePaths;
        long timeOut = 0L;
        LinkedList<Plugin> plugins = Lists.newLinkedList();
        JsonArray gatewayConfig = new JsonArray();
        if (data.containsKey("load")) {
            resolvedFilesLoad.addAll(this.createFileInfos((List)data.get("load"), false));
        }
        if (data.containsKey("test")) {
            testFiles.addAll(this.createFileInfos((List)data.get("test"), false));
        }
        if (data.containsKey("exclude")) {
            resolvedFilesExclude.addAll(this.createFileInfos((List)data.get("exclude"), false));
        }
        if (data.containsKey("server")) {
            server = (String)data.get("server");
        }
        if (data.containsKey("plugin")) {
            for (Map value : (List)data.get("plugin")) {
                plugins.add(new Plugin((String)value.get("name"), (String)value.get("jar"), (String)value.get("module"), this.createArgsList((String)value.get("args"))));
            }
        }
        if (data.containsKey("serve")) {
            Set<FileInfo> resolvedServeFiles = this.createFileInfos((List)data.get("serve"), true);
            resolvedFilesLoad.addAll(resolvedServeFiles);
        }
        if (data.containsKey("doctype")) {
            doctype = this.docTypeParser.parse((String)data.get("doctype"));
        }
        if (data.containsKey("timeout")) {
            timeOut = (Long)data.get("timeout");
        }
        if (data.containsKey("basepath")) {
            Object rawBasePaths = data.get("basepath");
            ArrayList<String> stringBasePaths = Lists.newArrayList();
            if (rawBasePaths instanceof String) {
                stringBasePaths.add((String)data.get("basepath"));
            } else if (rawBasePaths instanceof List) {
                stringBasePaths.addAll((List)rawBasePaths);
            }
            for (String stringPath : stringBasePaths) {
                File basePath = new File(stringPath);
                if (!basePath.isAbsolute()) {
                    basePaths = basePaths.applyRelativePath(stringPath);
                    continue;
                }
                basePaths.add(basePath);
            }
        }
        if (data.containsKey("proxy")) {
            this.copyDataToGatewayConfig(data, "proxy", gatewayConfig);
        }
        if (data.containsKey("gateway")) {
            this.copyDataToGatewayConfig(data, "gateway", gatewayConfig);
        }
        return new ParsedConfiguration(resolvedFilesLoad, resolvedFilesExclude, plugins, server, timeOut, basePaths, Lists.newArrayList(testFiles), gatewayConfig, doctype);
    }

    private void copyDataToGatewayConfig(Map<Object, Object> data, String key, JsonArray gatewayConfig) {
        for (Map value : (List)data.get(key)) {
            JsonObject entry = new JsonObject();
            if (value.containsKey("matcher")) {
                entry.addProperty("matcher", (String)value.get("matcher"));
            }
            if (value.containsKey("server")) {
                entry.addProperty("server", (String)value.get("server"));
            }
            if (value.containsKey("status")) {
                entry.addProperty("status", (Number)value.get("status"));
            }
            if (value.containsKey("responseHeaders")) {
                Map responseHeaders = (Map)value.get("responseHeaders");
                JsonObject jsonHeaders = new JsonObject();
                for (Map.Entry jsonEntry : responseHeaders.entrySet()) {
                    jsonHeaders.addProperty((String)jsonEntry.getKey(), (String)jsonEntry.getValue());
                }
                entry.add("responseHeaders", jsonHeaders);
            }
            if (value.containsKey("contentType")) {
                entry.addProperty("contentType", (String)value.get("contentType"));
            }
            if (value.containsKey("responseText")) {
                entry.addProperty("responseText", (String)value.get("responseText"));
            }
            gatewayConfig.add(entry);
        }
    }

    private List<String> createArgsList(String args) {
        String[] splittedArgs;
        if (args == null) {
            return Collections.emptyList();
        }
        LinkedList<String> argsList = Lists.newLinkedList();
        for (String arg : splittedArgs = args.split(",")) {
            argsList.add(arg.trim());
        }
        return argsList;
    }

    private Set<FileInfo> createFileInfos(List<String> files, boolean serveOnly) {
        if (files != null) {
            LinkedHashSet<FileInfo> fileInfos = new LinkedHashSet<FileInfo>();
            for (String f : files) {
                boolean isPatch = f.startsWith("patch");
                if (isPatch) {
                    String[] tokens = f.split(" ", 2);
                    f = tokens[1].trim();
                }
                fileInfos.add(new FileInfo(f, -1L, -1L, isPatch, serveOnly, null, f));
            }
            return fileInfos;
        }
        return Collections.emptySet();
    }
}

