/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.server.gateway;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockResponse {
    public static final String STATUS = "status";
    public static final String RESPONSE_HEADERS = "responseHeaders";
    public static final String CONTENT_TYPE = "contentType";
    public static final String RESPONSE_TEXT = "responseText";
    final Integer status;
    final ImmutableMap<String, String> responseHeaders;
    final String contentType;
    final String responseText;

    public static boolean entryDescribesMockResponse(JsonObject entry) {
        return entry.has(STATUS) || entry.has(RESPONSE_HEADERS) || entry.has(CONTENT_TYPE) || entry.has(RESPONSE_TEXT);
    }

    public static MockResponse buildFromEntry(JsonObject entry) {
        Integer status = null;
        ImmutableMap responseHeaders = null;
        String contentType = null;
        String responseText = null;
        if (entry.has(STATUS)) {
            status = entry.get(STATUS).getAsInt();
        }
        if (entry.has(RESPONSE_HEADERS)) {
            JsonObject jsonHeaders = entry.get(RESPONSE_HEADERS).getAsJsonObject();
            ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
            for (Map.Entry<String, JsonElement> jsonEntry : jsonHeaders.entrySet()) {
                builder.put(jsonEntry.getKey(), jsonEntry.getValue().getAsString());
            }
            responseHeaders = builder.build();
        }
        if (entry.has(CONTENT_TYPE)) {
            contentType = entry.get(CONTENT_TYPE).getAsString();
        }
        if (entry.has(RESPONSE_TEXT)) {
            responseText = entry.get(RESPONSE_TEXT).getAsString();
        }
        return new MockResponse(status, responseHeaders, contentType, responseText);
    }

    public MockResponse(Integer status, ImmutableMap<String, String> responseHeaders, String contentType, String responseText) {
        this.status = status;
        this.responseHeaders = responseHeaders;
        this.contentType = contentType;
        this.responseText = responseText;
    }

    public void writeTo(HttpServletResponse response) throws IOException {
        if (this.status != null) {
            response.setStatus(this.status);
        }
        if (this.responseHeaders != null) {
            for (Map.Entry entry : this.responseHeaders.entrySet()) {
                response.setHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.contentType != null) {
            response.setContentType(this.contentType);
        }
        if (this.responseText != null) {
            response.getWriter().write(this.responseText);
        }
    }
}

