/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.util;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class ManifestLoader {
    public Manifest load(String jarPath) throws ManifestNotFound {
        File jarFile = new File(jarPath);
        try {
            JarFile jar = new JarFile(jarFile);
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                throw new ManifestNotFound("Could not load manifest from jar:" + jarPath);
            }
            return manifest;
        }
        catch (IOException e) {
            throw new ManifestNotFound("Could not load manifest from jar:" + jarPath, e);
        }
    }

    public class ManifestNotFound
    extends Exception {
        private static final long serialVersionUID = 3137031869991435071L;

        public ManifestNotFound(String message) {
            super(message);
        }

        public ManifestNotFound(String message, IOException e) {
            super(message, e);
        }
    }
}

