/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.collect.Lists;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.PathResolver;
import com.google.jstestdriver.PathRewriter;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.config.ConfigurationException;
import com.google.jstestdriver.hooks.FileParsePostProcessor;
import com.google.jstestdriver.model.BasePaths;
import com.google.jstestdriver.util.DisplayPathSanitizer;
import java.io.File;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.oro.io.GlobFilenameFilter;
import org.jvyaml.YAML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ConfigurationParser {
    private static final List<String> EMPTY_LIST = Lists.newArrayList();
    private final Set<FileInfo> filesList = new LinkedHashSet<FileInfo>();
    private final File basePath;
    private final Reader configReader;
    private final PathRewriter pathRewriter;
    private String server = "";
    private List<Plugin> plugins = new LinkedList<Plugin>();
    private PathResolver pathResolver;

    public ConfigurationParser(File basePath, Reader configReader, PathRewriter pathRewriter) {
        this.basePath = basePath;
        this.configReader = configReader;
        this.pathRewriter = pathRewriter;
        this.pathResolver = new PathResolver(new BasePaths(basePath), Collections.<FileParsePostProcessor>emptySet(), new DisplayPathSanitizer());
    }

    public void parse() {
        Map data = (Map)YAML.load(this.configReader);
        LinkedHashSet<FileInfo> resolvedFilesLoad = new LinkedHashSet<FileInfo>();
        LinkedHashSet<FileInfo> resolvedFilesExclude = new LinkedHashSet<FileInfo>();
        if (data.containsKey("load")) {
            resolvedFilesLoad.addAll(this.resolveFiles((List)data.get("load"), false));
        }
        if (data.containsKey("exclude")) {
            resolvedFilesExclude.addAll(this.resolveFiles((List)data.get("exclude"), false));
        }
        if (data.containsKey("server")) {
            this.server = (String)data.get("server");
        }
        if (data.containsKey("plugin")) {
            for (Map value : (List)data.get("plugin")) {
                this.plugins.add(new Plugin((String)value.get("name"), (String)value.get("jar"), (String)value.get("module"), this.createArgsList((String)value.get("args"))));
            }
        }
        if (data.containsKey("serve")) {
            Set<FileInfo> resolvedServeFiles = this.resolveFiles((List)data.get("serve"), true);
            resolvedFilesLoad.addAll(resolvedServeFiles);
        }
        this.filesList.addAll(this.consolidatePatches(resolvedFilesLoad));
        this.filesList.removeAll(resolvedFilesExclude);
    }

    private List<String> createArgsList(String args) {
        String[] splittedArgs;
        if (args == null) {
            return EMPTY_LIST;
        }
        LinkedList<String> argsList = Lists.newLinkedList();
        for (String arg : splittedArgs = args.split(",")) {
            argsList.add(arg.trim());
        }
        return argsList;
    }

    private Set<FileInfo> consolidatePatches(Set<FileInfo> resolvedFilesLoad) {
        LinkedHashSet<FileInfo> consolidated = new LinkedHashSet<FileInfo>(resolvedFilesLoad.size());
        FileInfo currentNonPatch = null;
        for (FileInfo fileInfo : resolvedFilesLoad) {
            if (fileInfo.isPatch()) {
                if (currentNonPatch == null) {
                    throw new IllegalStateException("Patch " + fileInfo + " without a core file to patch");
                }
                currentNonPatch.addPatch(fileInfo);
                continue;
            }
            consolidated.add(fileInfo);
            currentNonPatch = fileInfo;
        }
        return consolidated;
    }

    private Set<FileInfo> resolveFiles(List<String> files, boolean serveOnly) {
        if (files != null) {
            LinkedHashSet<FileInfo> resolvedFiles = new LinkedHashSet<FileInfo>();
            for (String f : files) {
                String pattern;
                boolean isPatch = (f = this.pathRewriter.rewrite(f)).startsWith("patch");
                if (isPatch) {
                    String[] tokens = f.split(" ", 2);
                    f = tokens[1].trim();
                }
                if (f.startsWith("http://") || f.startsWith("https://")) {
                    resolvedFiles.add(new FileInfo(f, -1L, -1L, false, false, null, f));
                    continue;
                }
                File file = this.basePath != null ? new File(this.basePath.getAbsoluteFile(), f) : new File(f);
                File testFile = file.getAbsoluteFile();
                File dir = testFile.getParentFile().getAbsoluteFile();
                String[] filteredFiles = dir.list(new GlobFilenameFilter(pattern = file.getName(), 1));
                if (filteredFiles == null || filteredFiles.length == 0) {
                    String error = "The patterns/paths " + f + " used in the configuration" + " file didn't match any file, the files patterns/paths need to be relative to" + " the configuration file.";
                    throw new ConfigurationException(error);
                }
                Arrays.sort(filteredFiles, String.CASE_INSENSITIVE_ORDER);
                for (String filteredFile : filteredFiles) {
                    FileInfo resolvedFile = this.pathResolver.resolvePathToFileInfo(dir.getPath() + File.separator + filteredFile, isPatch, serveOnly);
                    resolvedFiles.add(resolvedFile);
                }
            }
            return resolvedFiles;
        }
        return Collections.emptySet();
    }

    public Set<FileInfo> getFilesList() {
        return this.filesList;
    }

    public String getServer() {
        return this.server;
    }

    public String getCaptureAddress() {
        return this.server;
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }
}

