/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryProvider;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.google.jstestdriver.Action;
import com.google.jstestdriver.ActionFactoryModule;
import com.google.jstestdriver.ActionListProvider;
import com.google.jstestdriver.BrowserAction;
import com.google.jstestdriver.DefaultResponseStreamFactory;
import com.google.jstestdriver.FailureAccumulator;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.FileSetProvider;
import com.google.jstestdriver.Flags;
import com.google.jstestdriver.JsTestDriverClient;
import com.google.jstestdriver.JsTestDriverServer;
import com.google.jstestdriver.JsTestDriverServerImpl;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.Time;
import com.google.jstestdriver.TimeImpl;
import com.google.jstestdriver.action.ConfigureGatewayAction;
import com.google.jstestdriver.annotations.BrowserCount;
import com.google.jstestdriver.browser.BrowserControl;
import com.google.jstestdriver.browser.BrowserRunner;
import com.google.jstestdriver.guice.BrowserActionProvider;
import com.google.jstestdriver.guice.FlagsModule;
import com.google.jstestdriver.hooks.ServerListener;
import com.google.jstestdriver.hooks.TestListener;
import com.google.jstestdriver.model.BasePaths;
import com.google.jstestdriver.output.MultiTestResultListener;
import java.io.File;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsTestDriverModule
extends AbstractModule {
    private static final Logger logger = LoggerFactory.getLogger(JsTestDriverModule.class);
    private final Flags flags;
    private final Set<FileInfo> fileSet;
    private final String serverAddress;
    private final String captureAddress;
    private final PrintStream outputStream;
    private final BasePaths basePaths;
    private final long testSuiteTimeout;
    private final List<FileInfo> tests;
    private final List<FileInfo> plugins;
    private final JsonArray gatewayConfig;

    public JsTestDriverModule(Flags flags, Set<FileInfo> fileSet, String serverAddress, String captureAddress, PrintStream outputStream, File basePath) {
        this(flags, fileSet, serverAddress, captureAddress, outputStream, new BasePaths(basePath), 7200L, Collections.emptyList(), Collections.emptyList(), new JsonArray());
    }

    public JsTestDriverModule(Flags flags, Set<FileInfo> fileSet, String serverAddress, String captureAddress, PrintStream outputStream, BasePaths basePaths, long testSuiteTimeout, List<FileInfo> tests, List<FileInfo> plugins, JsonArray gatewayConfig) {
        this.flags = flags;
        this.fileSet = fileSet;
        this.serverAddress = serverAddress;
        this.captureAddress = captureAddress;
        this.outputStream = outputStream;
        this.basePaths = basePaths;
        this.testSuiteTimeout = testSuiteTimeout;
        this.tests = tests;
        this.plugins = plugins;
        this.gatewayConfig = gatewayConfig;
    }

    @Override
    protected void configure() {
        if (logger.isDebugEnabled()) {
            logger.debug("Configured with:\nflags:{}\nFiles:{}\nserver:{}\ncaptureAddress:{}\noutputStream:{}\nbasePath:{}\ntestSuiteTimeout:{}\ntests:{}\nplugins:{}\ngateway:{}", new Object[]{this.flags, this.fileSet, this.serverAddress, this.captureAddress, this.outputStream, this.basePaths, this.testSuiteTimeout, this.tests, this.plugins, this.gatewayConfig});
        }
        this.bind(PrintStream.class).annotatedWith(Names.named("outputStream")).toInstance(this.outputStream);
        Preconditions.checkArgument(this.serverAddress != null && this.serverAddress.length() > 0 && this.serverAddress.startsWith("http"), "The server address cannot be empty, null, or missing the protocol:" + this.serverAddress);
        this.bind(String.class).annotatedWith(Names.named("server")).toInstance(this.serverAddress);
        this.bind(String.class).annotatedWith(Names.named("captureAddress")).toInstance(this.captureAddress);
        this.bind(new TypeLiteral<Set<FileInfo>>(){}).annotatedWith(Names.named("originalFileSet")).toInstance(this.fileSet);
        this.bind(new TypeLiteral<List<Action>>(){}).toProvider(ActionListProvider.class);
        this.bind(new TypeLiteral<List<BrowserAction>>(){}).toProvider(BrowserActionProvider.class);
        this.bind(ExecutorService.class).toInstance(Executors.newScheduledThreadPool(10));
        this.bind(FailureAccumulator.class).in(Singleton.class);
        this.bind(Long.class).annotatedWith(Names.named("testSuiteTimeout")).toInstance(this.testSuiteTimeout);
        this.bind(BasePaths.class).toInstance(this.basePaths);
        this.install(new FlagsModule(this.flags));
        this.install(new ActionFactoryModule());
        for (BrowserRunner runner : this.flags.getBrowser()) {
            Multibinder.newSetBinder(this.binder(), BrowserRunner.class).addBinding().toInstance(runner);
        }
        this.bind(Time.class).to(TimeImpl.class);
        this.bind(new TypeLiteral<Set<FileInfo>>(){}).annotatedWith(Names.named("fileSet")).toProvider(FileSetProvider.class).in(Singleton.class);
        this.bind(new TypeLiteral<List<FileInfo>>(){}).annotatedWith(Names.named("tests")).toInstance(this.tests);
        this.bind(new TypeLiteral<List<FileInfo>>(){}).annotatedWith(Names.named("plugins")).toInstance(this.plugins);
        this.bind(Integer.class).annotatedWith(BrowserCount.class).toProvider(BrowserCountProvider.class).in(Singleton.class);
        this.bind(JsonArray.class).annotatedWith(Names.named("gateway")).toInstance(this.gatewayConfig);
        Multibinder.newSetBinder(this.binder(), ServerListener.class);
        this.bind(ConfigureGatewayAction.Factory.class).toProvider(FactoryProvider.newFactory(ConfigureGatewayAction.Factory.class, ConfigureGatewayAction.class));
        this.bind(JsTestDriverServer.Factory.class).toProvider(FactoryProvider.newFactory(JsTestDriverServer.Factory.class, JsTestDriverServerImpl.class));
        this.bind(BrowserControl.BrowserControlFactory.class).toProvider(FactoryProvider.newFactory(BrowserControl.BrowserControlFactory.class, BrowserControl.class));
        this.bind(TestListener.class).to(MultiTestResultListener.class);
        Multibinder.newSetBinder(this.binder(), ResponseStreamFactory.class).addBinding().to(DefaultResponseStreamFactory.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BrowserCountProvider
    implements Provider<Integer> {
        private final JsTestDriverClient client;

        @Inject
        public BrowserCountProvider(JsTestDriverClient client) {
            this.client = client;
        }

        @Override
        public synchronized Integer get() {
            try {
                return this.client.listBrowsers().size();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot inject the browser count until the server has started. Try injecting a Provider of it instead.", e);
            }
        }
    }
}

