/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.FileInfo;

public class FileSource {
    private String fileSrc;
    private String basePath;
    private long timestamp;
    private long length;

    public FileSource() {
    }

    public FileSource(String fileSrc, String basePath, long timestamp, long length) {
        this.fileSrc = fileSrc;
        this.basePath = basePath;
        this.timestamp = timestamp;
        this.length = length;
    }

    public String getFileSrc() {
        return this.fileSrc;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setFileSource(String fileSrc) {
        this.fileSrc = fileSrc;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String toString() {
        return String.format("%s(%s, %s, %s)", this.getClass().getSimpleName(), this.fileSrc, this.basePath, this.timestamp);
    }

    public FileInfo toFileInfo(String contents) {
        return new FileInfo(this.getBasePath(), this.getTimestamp(), this.getLength(), false, false, contents, this.getFileSrc());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.basePath == null ? 0 : this.basePath.hashCode());
        result = 31 * result + (this.fileSrc == null ? 0 : this.fileSrc.hashCode());
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileSource other = (FileSource)obj;
        if (this.basePath == null ? other.basePath != null : !this.basePath.equals(other.basePath)) {
            return false;
        }
        if (this.fileSrc == null ? other.fileSrc != null : !this.fileSrc.equals(other.fileSrc)) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        return this.timestamp == other.timestamp;
    }
}

