/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.config.UnreadableFile;
import com.google.jstestdriver.config.UnreadableFilesException;
import com.google.jstestdriver.hooks.FileParsePostProcessor;
import com.google.jstestdriver.model.BasePaths;
import com.google.jstestdriver.util.DisplayPathSanitizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.oro.io.GlobFilenameFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathResolver {
    private static final Logger logger = LoggerFactory.getLogger(PathResolver.class);
    private final Set<FileParsePostProcessor> processors;
    private final BasePaths basePaths;
    private DisplayPathSanitizer sanitizer;

    @Inject
    public PathResolver(BasePaths basePaths, Set<FileParsePostProcessor> processors, DisplayPathSanitizer sanitizer) {
        this.basePaths = basePaths;
        this.processors = processors;
        this.sanitizer = sanitizer;
    }

    private Set<FileInfo> consolidatePatches(Set<FileInfo> resolvedFilesLoad) {
        LinkedHashSet<FileInfo> consolidated = new LinkedHashSet<FileInfo>(resolvedFilesLoad.size());
        FileInfo currentNonPatch = null;
        for (FileInfo fileInfo : resolvedFilesLoad) {
            if (fileInfo.isPatch()) {
                if (currentNonPatch == null) {
                    throw new IllegalStateException("Patch " + fileInfo + " without a core file to patch");
                }
                currentNonPatch.addPatch(fileInfo);
                continue;
            }
            consolidated.add(fileInfo);
            currentNonPatch = fileInfo;
        }
        return consolidated;
    }

    public Set<FileInfo> resolve(Set<FileInfo> unresolvedFiles) {
        Set<FileInfo> resolvedFiles = new LinkedHashSet<FileInfo>();
        LinkedList<UnreadableFile> unreadable = Lists.newLinkedList();
        for (FileInfo fileInfo : unresolvedFiles) {
            String filePath = fileInfo.getFilePath();
            if (fileInfo.isWebAddress()) {
                resolvedFiles.add(fileInfo.fromResolvedPath(filePath, filePath, -1L));
                continue;
            }
            this.expandFileInfosFromFileInfo(resolvedFiles, unreadable, fileInfo, filePath);
        }
        if (!unreadable.isEmpty()) {
            throw new UnreadableFilesException(unreadable);
        }
        resolvedFiles = this.postProcessFiles(resolvedFiles);
        return this.consolidatePatches(resolvedFiles);
    }

    private void expandFileInfosFromFileInfo(Set<FileInfo> resolvedFiles, List<UnreadableFile> unreadable, FileInfo fileInfo, String filePath) {
        ArrayList unresolvedPaths = Lists.newArrayListWithCapacity(this.basePaths.size());
        for (File basePath : this.basePaths) {
            File file = new File(basePath, filePath);
            File absoluteDir = file.getParentFile().getAbsoluteFile();
            String[] expandedFileNames = this.expandGlob(absoluteDir.getAbsolutePath(), file.getName(), absoluteDir);
            if (expandedFileNames == null) continue;
            for (String fileName : expandedFileNames) {
                File sourceFile = new File(absoluteDir, fileName);
                this.createFileInfo(resolvedFiles, unreadable, fileInfo, sourceFile, basePath);
            }
            return;
        }
        unreadable.add(new UnreadableFile(fileInfo.getFilePath(), this.basePaths.toErrorString(fileInfo.getFilePath())));
    }

    private void createFileInfo(Set<FileInfo> resolvedFiles, List<UnreadableFile> unreadable, FileInfo fileInfo, File sourceFile, File basePath) {
        if (!sourceFile.canRead()) {
            unreadable.add(new UnreadableFile(fileInfo.getFilePath(), sourceFile.getAbsolutePath()));
        } else {
            String absolutePath = this.resolveRelativePathReferences(sourceFile.getAbsolutePath());
            String displayPath = this.sanitizer.sanitize(absolutePath, basePath);
            File resolvedFile = new File(absolutePath);
            long timestamp = resolvedFile.lastModified();
            FileInfo newFileInfo = fileInfo.fromResolvedPath(absolutePath, displayPath, timestamp);
            resolvedFiles.add(newFileInfo);
        }
    }

    public File resolvePath(String filePath) {
        return this.resolvePathToFileInfo(filePath, false, false).toFile();
    }

    public FileInfo resolvePathToFileInfo(String path, boolean isPatch, boolean serveOnly) {
        for (File basePath : this.basePaths) {
            File resolved = this.resolvePath(path, basePath);
            if (resolved == null) continue;
            return new FileInfo(resolved.getAbsolutePath(), resolved.lastModified(), resolved.length(), isPatch, serveOnly, null, this.sanitizer.sanitize(resolved.getAbsolutePath(), basePath));
        }
        throw new UnreadableFilesException(Lists.newArrayList(new UnreadableFile(path, this.basePaths.toErrorString(path))));
    }

    private File resolvePath(String filePath, File basePath) {
        File resolved;
        File absolute = new File(filePath);
        if (!absolute.isAbsolute()) {
            absolute = new File(basePath, filePath);
        }
        if ((resolved = new File(this.resolveRelativePathReferences(absolute.getAbsolutePath()))).canRead()) {
            return resolved;
        }
        return null;
    }

    private String resolveRelativePathReferences(String path) {
        Pattern pattern = Pattern.compile(Pattern.quote(File.separator));
        String[] elements = pattern.split(path);
        ArrayList<String> resolved = Lists.newArrayListWithExpectedSize(elements.length);
        for (String element : elements) {
            if ("..".equals(element)) {
                resolved.remove(resolved.size() - 1);
                continue;
            }
            resolved.add(element);
        }
        return Joiner.on(File.separator).join(resolved);
    }

    private String[] expandGlob(String filePath, String fileNamePattern, File dir) {
        String[] filteredFiles = dir.list(new GlobFilenameFilter(fileNamePattern, 1));
        if (filteredFiles == null || filteredFiles.length == 0) {
            return null;
        }
        Arrays.sort(filteredFiles, String.CASE_INSENSITIVE_ORDER);
        return filteredFiles;
    }

    public List<Plugin> resolve(List<Plugin> plugins) {
        LinkedList<UnreadableFile> unreadable = Lists.newLinkedList();
        LinkedList<Plugin> resolved = Lists.newLinkedList();
        for (Plugin plugin : plugins) {
            File resolvedFile = this.resolvePath(plugin.getPathToJar());
            resolved.add(plugin.getPluginFromPath(resolvedFile.getAbsolutePath()));
        }
        if (!unreadable.isEmpty()) {
            throw new UnreadableFilesException(unreadable);
        }
        return resolved;
    }

    private Set<FileInfo> postProcessFiles(Set<FileInfo> resolvedFiles) {
        Set<FileInfo> processedFiles = resolvedFiles;
        for (FileParsePostProcessor processor : this.processors) {
            processedFiles = processor.process(resolvedFiles);
        }
        return processedFiles;
    }
}

