/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.hooks.PluginInitializer;
import com.google.jstestdriver.util.ManifestLoader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader {
    final ManifestLoader manifestLoader = new ManifestLoader();

    public List<Module> load(List<Plugin> plugins) {
        LinkedList<Module> modules = new LinkedList<Module>();
        for (Plugin plugin : plugins) {
            try {
                URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{new URL("jar:file:" + plugin.getPathToJar() + "!/")}, this.getClass().getClassLoader());
                Class<?> module = this.getPluginMainClass(plugin, urlClassLoader);
                modules.add(this.getModuleInstance(plugin, module));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return modules;
    }

    private Class<?> getPluginMainClass(Plugin plugin, URLClassLoader urlClassLoader) throws ClassNotFoundException {
        String moduleName = plugin.getModuleName(this.manifestLoader);
        if (moduleName != null && moduleName.length() > 0) {
            return Class.forName(moduleName, true, urlClassLoader);
        }
        String initializerName = plugin.getInitializerName(this.manifestLoader);
        if (initializerName != null && initializerName.length() > 0) {
            return Class.forName(initializerName, true, urlClassLoader);
        }
        throw new IllegalArgumentException("Cannot determine main class for " + plugin.getName(this.manifestLoader) + " please see http://code.google.com/p/js-test-driver/wiki/Plugins#mainclass.");
    }

    private Module getModuleInstance(Plugin plugin, Class<?> mainClass) {
        try {
            if (PluginInitializer.class.isAssignableFrom(mainClass)) {
                return new InitializerModule(mainClass);
            }
            Constructor<PluginInitializer> argsConstructor = mainClass.getConstructor(List.class);
            return (Module)((Object)argsConstructor.newInstance(plugin.getArgs()));
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            try {
                return (Module)mainClass.newInstance();
            }
            catch (InstantiationException e1) {
                throw new RuntimeException(e1);
            }
            catch (IllegalAccessException e1) {
                throw new RuntimeException(e1);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InitializerModule
    implements Module {
        private final Class<PluginInitializer> initializer;

        public InitializerModule(Class<PluginInitializer> initializer) {
            this.initializer = initializer;
        }

        @Override
        public void configure(Binder binder) {
            Multibinder.newSetBinder(binder, PluginInitializer.class).addBinding().to(this.initializer);
        }

        public String toString() {
            return String.format("InitializerModule [%s]", this.initializer);
        }
    }
}

