/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.google.jstestdriver.DryRunAction;
import com.google.jstestdriver.EvalAction;
import com.google.jstestdriver.FailureAccumulator;
import com.google.jstestdriver.ResetAction;
import com.google.jstestdriver.ResponseStream;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.RunTestsActionResponseStream;
import com.google.jstestdriver.TestResultGenerator;
import com.google.jstestdriver.hooks.TestListener;
import java.io.PrintStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResponseStreamFactory
implements ResponseStreamFactory {
    private final Provider<TestListener> resultListener;
    private final FailureAccumulator accumulator;
    private final PrintStream out;
    private final TestResultGenerator resultGenerator;

    @Inject
    public DefaultResponseStreamFactory(Provider<TestListener> responsePrinterFactory, FailureAccumulator accumulator, @Named(value="outputStream") PrintStream out, TestResultGenerator resultGenerator) {
        this.resultListener = responsePrinterFactory;
        this.accumulator = accumulator;
        this.out = out;
        this.resultGenerator = resultGenerator;
    }

    @Override
    public ResponseStream getRunTestsActionResponseStream(String browserId) {
        TestListener listener = this.resultListener.get();
        RunTestsActionResponseStream responseStream = new RunTestsActionResponseStream(this.resultGenerator, listener, this.accumulator);
        return responseStream;
    }

    @Override
    public ResponseStream getDryRunActionResponseStream() {
        return new DryRunAction.DryRunActionResponseStream(this.out, this.resultListener.get());
    }

    @Override
    public ResponseStream getEvalActionResponseStream() {
        return new EvalAction.EvalActionResponseStream(this.out);
    }

    @Override
    public ResponseStream getResetActionResponseStream() {
        return new ResetAction.ResetActionResponseStream(this.out);
    }
}

