/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.browser;

import com.google.inject.Inject;
import com.google.jstestdriver.BrowserInfo;
import com.google.jstestdriver.CapturedBrowsers;
import com.google.jstestdriver.SlaveBrowser;
import com.google.jstestdriver.Time;
import com.google.jstestdriver.annotations.BrowserTimeout;
import com.google.jstestdriver.model.HandlerPathPrefix;
import com.google.jstestdriver.runner.RunnerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserHunter {
    private static final Logger logger = LoggerFactory.getLogger(BrowserHunter.class.getName());
    private final CapturedBrowsers capturedBrowsers;
    private final long browserTimeout;
    private final HandlerPathPrefix prefix;
    private final Time time;

    @Inject
    public BrowserHunter(CapturedBrowsers capturedBrowsers, @BrowserTimeout long browserTimeout, HandlerPathPrefix prefix, Time time) {
        this.capturedBrowsers = capturedBrowsers;
        this.browserTimeout = browserTimeout;
        this.prefix = prefix;
        this.time = time;
    }

    public SlaveBrowser captureBrowser(String name, String version, String os) {
        return this.captureBrowser(this.capturedBrowsers.getUniqueId(), name, version, os, this.browserTimeout, "quirks", RunnerType.CLIENT, 50);
    }

    public SlaveBrowser captureBrowser(String rawId, String name, String version, String os) {
        return this.captureBrowser(rawId, name, version, os, this.browserTimeout, "quirks", RunnerType.CLIENT, 50);
    }

    public SlaveBrowser captureBrowser(String rawId, String name, String version, String os, Long browserTimeout, String mode, RunnerType type, Integer uploadSize) {
        BrowserInfo browserInfo = new BrowserInfo();
        Long id = this.parseBrowserId(rawId);
        browserInfo.setId(id);
        browserInfo.setName(name);
        browserInfo.setVersion(version);
        browserInfo.setOs(os);
        browserInfo.setUploadSize(uploadSize != null ? uploadSize : 50);
        long computedBrowserTimeout = this.computeTimeout(browserTimeout);
        SlaveBrowser slave = new SlaveBrowser(this.time, id.toString(), browserInfo, computedBrowserTimeout, this.prefix, mode, type, SlaveBrowser.BrowserState.CAPTURED, this.time.now());
        this.capturedBrowsers.addSlave(slave);
        logger.debug("Browser Captured: {}", slave);
        logger.info("Browser Captured: {} version {} ({})", new Object[]{name, version, id});
        return slave;
    }

    private long computeTimeout(Long browserTimeout) {
        return browserTimeout == null ? this.browserTimeout : browserTimeout;
    }

    private Long parseBrowserId(String id) {
        if (id == null) {
            return Long.parseLong(this.capturedBrowsers.getUniqueId());
        }
        return Long.parseLong(id);
    }

    public boolean isBrowserCaptured(String id) {
        return this.capturedBrowsers.getBrowser(id) != null;
    }

    public void freeBrowser(String id) {
        this.capturedBrowsers.removeSlave(id);
    }
}

