/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.config;

import com.google.gson.JsonArray;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.Flags;
import com.google.jstestdriver.PathResolver;
import com.google.jstestdriver.Plugin;
import com.google.jstestdriver.browser.DocType;
import com.google.jstestdriver.config.Configuration;
import com.google.jstestdriver.model.BasePaths;
import com.google.jstestdriver.model.HandlerPathPrefix;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfiguration
implements Configuration {
    public static final long DEFAULT_TEST_TIMEOUT = 7200L;
    private final BasePaths basePaths;

    public DefaultConfiguration(BasePaths basePaths) {
        this.basePaths = basePaths;
    }

    @Override
    public Set<FileInfo> getFilesList() {
        return Collections.emptySet();
    }

    @Override
    public List<Plugin> getPlugins() {
        return Collections.emptyList();
    }

    @Override
    public String getServer(String flagValue, int port, HandlerPathPrefix handlerPrefix) {
        if (flagValue != null && !flagValue.isEmpty()) {
            return handlerPrefix.suffixServer(flagValue);
        }
        if (port == -1) {
            throw new RuntimeException("Oh Snap! No server defined!");
        }
        return handlerPrefix.suffixServer(String.format("http://%s:%d", "127.0.0.1", port));
    }

    @Override
    public String getCaptureAddress(String server, String captureAddress, HandlerPathPrefix prefix) {
        if (captureAddress != null && !captureAddress.isEmpty()) {
            return prefix.suffixServer(captureAddress);
        }
        return server;
    }

    @Override
    public Configuration resolvePaths(PathResolver resolver, Flags flags) {
        return this;
    }

    @Override
    public long getTestSuiteTimeout() {
        return 7200L;
    }

    @Override
    public List<FileInfo> getTests() {
        return Collections.emptyList();
    }

    @Override
    public BasePaths getBasePaths() {
        return this.basePaths;
    }

    @Override
    public JsonArray getGatewayConfiguration() {
        return new JsonArray();
    }

    @Override
    public DocType getDocType() {
        return null;
    }
}

