from django.db import models
from django.core.exceptions import ValidationError
from django.utils.translation import ugettext as _
from django_th.models.services import Services

"""
    https://dev.twitter.com/rest/public/timelines
    https://dev.twitter.com/rest/reference/get/statuses/user_timeline
    https://dev.twitter.com/rest/reference/get/search/tweets

    Twitter model
    this permits to search tag or screen
    and store the last reached tweet_id with since_id, max_id, count
"""


class Twitter(Services):

    tag = models.CharField(max_length=80, null=True, blank=True)
    screen = models.CharField(max_length=80, null=True, blank=True)
    since_id = models.IntegerField(null=True, blank=True)
    max_id = models.IntegerField(null=True, blank=True)
    count = models.IntegerField(null=True, blank=True)
    trigger = models.ForeignKey('TriggerService')

    class Meta:
        app_label = 'django_th'

    def clean(self):
        # check if one of the field is filled
        if self.tag == '' and self.screen == '':
            raise ValidationError(
                _("You have to fill ONE of the both fields (or all together)"))

    def __unicode__(self):
        return "%s" % (self.screen)

    def show(self):
        return "My Twitter %s %s" % (self.screen, self.tag)
