from datetime import timedelta
from django.test import TestCase
from timedeltatemplatefilter.templatetags.timedelta_filter import timedelta as the_filter


class SimpleTestCase(TestCase):
    
    def test_seconds_only_2(self):
        test_value = timedelta(seconds=2)
        self.assertEqual(the_filter(test_value, '{seconds}'), '2')
        self.assertEqual(the_filter(test_value, '{seconds_total}'), '2')
        self.assertEqual(the_filter(test_value, '{seconds2}'), '02')
        self.assertEqual(the_filter(test_value, '{minutes}'), '0')
        self.assertEqual(the_filter(test_value, '{minutes_total}'), '0')
        self.assertEqual(the_filter(test_value, '{minutes2}'), '00')
        self.assertEqual(the_filter(test_value, '{hours}'), '0')
        self.assertEqual(the_filter(test_value, '{hours_total}'), '0')
        self.assertEqual(the_filter(test_value, '{hours2}'), '00')
        self.assertEqual(the_filter(test_value, '{days}'), '0')
        self.assertEqual(the_filter(test_value, '{days_total}'), '0')
        self.assertEqual(the_filter(test_value, '{years}'), '0')
        self.assertEqual(the_filter(test_value, '{years_total}'), '0')

    def test_seconds_only_42(self):
        test_value = timedelta(seconds=42)
        self.assertEqual(the_filter(test_value, '{seconds}'), '42')
        self.assertEqual(the_filter(test_value, '{seconds_total}'), '42')
        self.assertEqual(the_filter(test_value, '{seconds2}'), '42')
        self.assertEqual(the_filter(test_value, '{minutes}'), '0')
        self.assertEqual(the_filter(test_value, '{minutes_total}'), '0')
        self.assertEqual(the_filter(test_value, '{minutes2}'), '00')
        self.assertEqual(the_filter(test_value, '{hours}'), '0')
        self.assertEqual(the_filter(test_value, '{hours_total}'), '0')
        self.assertEqual(the_filter(test_value, '{hours2}'), '00')
        self.assertEqual(the_filter(test_value, '{days}'), '0')
        self.assertEqual(the_filter(test_value, '{days_total}'), '0')
        self.assertEqual(the_filter(test_value, '{years}'), '0')
        self.assertEqual(the_filter(test_value, '{years_total}'), '0')

    def test_minutes_only_3(self):
        test_value = timedelta(seconds=3*60)
        self.assertEqual(the_filter(test_value, '{seconds}'), '0')
        self.assertEqual(the_filter(test_value, '{seconds_total}'), '180')
        self.assertEqual(the_filter(test_value, '{seconds2}'), '00')
        self.assertEqual(the_filter(test_value, '{minutes}'), '3')
        self.assertEqual(the_filter(test_value, '{minutes_total}'), '3')
        self.assertEqual(the_filter(test_value, '{minutes2}'), '03')
        self.assertEqual(the_filter(test_value, '{hours}'), '0')
        self.assertEqual(the_filter(test_value, '{hours_total}'), '0')
        self.assertEqual(the_filter(test_value, '{hours2}'), '00')
        self.assertEqual(the_filter(test_value, '{days}'), '0')
        self.assertEqual(the_filter(test_value, '{days_total}'), '0')
        self.assertEqual(the_filter(test_value, '{years}'), '0')
        self.assertEqual(the_filter(test_value, '{years_total}'), '0')

    def test_minutes_only_32(self):
        test_value = timedelta(seconds=32*60)
        self.assertEqual(the_filter(test_value, '{seconds}'), '0')
        self.assertEqual(the_filter(test_value, '{seconds_total}'), '1920')
        self.assertEqual(the_filter(test_value, '{seconds2}'), '00')
        self.assertEqual(the_filter(test_value, '{minutes}'), '32')
        self.assertEqual(the_filter(test_value, '{minutes_total}'), '32')
        self.assertEqual(the_filter(test_value, '{minutes2}'), '32')
        self.assertEqual(the_filter(test_value, '{hours}'), '0')
        self.assertEqual(the_filter(test_value, '{hours_total}'), '0')
        self.assertEqual(the_filter(test_value, '{hours2}'), '00')
        self.assertEqual(the_filter(test_value, '{days}'), '0')
        self.assertEqual(the_filter(test_value, '{days_total}'), '0')
        self.assertEqual(the_filter(test_value, '{years}'), '0')
        self.assertEqual(the_filter(test_value, '{years_total}'), '0')

    def test_hounrs_only_7(self):
        test_value = timedelta(seconds=7*3600)
        self.assertEqual(the_filter(test_value, '{seconds}'), '0')
        self.assertEqual(the_filter(test_value, '{seconds_total}'), '25200')
        self.assertEqual(the_filter(test_value, '{seconds2}'), '00')
        self.assertEqual(the_filter(test_value, '{minutes}'), '0')
        self.assertEqual(the_filter(test_value, '{minutes_total}'), '420')
        self.assertEqual(the_filter(test_value, '{minutes2}'), '00')
        self.assertEqual(the_filter(test_value, '{hours}'), '7')
        self.assertEqual(the_filter(test_value, '{hours_total}'), '7')
        self.assertEqual(the_filter(test_value, '{hours2}'), '07')
        self.assertEqual(the_filter(test_value, '{days}'), '0')
        self.assertEqual(the_filter(test_value, '{days_total}'), '0')
        self.assertEqual(the_filter(test_value, '{years}'), '0')
        self.assertEqual(the_filter(test_value, '{years_total}'), '0')

    def test_hours_only_17(self):
        test_value = timedelta(seconds=17*3600)
        self.assertEqual(the_filter(test_value, '{seconds}'), '0')
        self.assertEqual(the_filter(test_value, '{seconds_total}'), '61200')
        self.assertEqual(the_filter(test_value, '{seconds2}'), '00')
        self.assertEqual(the_filter(test_value, '{minutes}'), '0')
        self.assertEqual(the_filter(test_value, '{minutes_total}'), '1020')
        self.assertEqual(the_filter(test_value, '{minutes2}'), '00')
        self.assertEqual(the_filter(test_value, '{hours}'), '17')
        self.assertEqual(the_filter(test_value, '{hours_total}'), '17')
        self.assertEqual(the_filter(test_value, '{hours2}'), '17')
        self.assertEqual(the_filter(test_value, '{days}'), '0')
        self.assertEqual(the_filter(test_value, '{days_total}'), '0')
        self.assertEqual(the_filter(test_value, '{years}'), '0')
        self.assertEqual(the_filter(test_value, '{years_total}'), '0')

    def test_days_only_4(self):
        test_value = timedelta(days=4)
        self.assertEqual(the_filter(test_value, '{seconds}'), '0')
        self.assertEqual(the_filter(test_value, '{seconds_total}'), '345600')
        self.assertEqual(the_filter(test_value, '{seconds2}'), '00')
        self.assertEqual(the_filter(test_value, '{minutes}'), '0')
        self.assertEqual(the_filter(test_value, '{minutes_total}'), '5760')
        self.assertEqual(the_filter(test_value, '{minutes2}'), '00')
        self.assertEqual(the_filter(test_value, '{hours}'), '0')
        self.assertEqual(the_filter(test_value, '{hours_total}'), '96')
        self.assertEqual(the_filter(test_value, '{hours2}'), '00')
        self.assertEqual(the_filter(test_value, '{days}'), '4')
        self.assertEqual(the_filter(test_value, '{days_total}'), '4')
        self.assertEqual(the_filter(test_value, '{years}'), '0')
        self.assertEqual(the_filter(test_value, '{years_total}'), '0')

    def test_days_only_74(self):
        test_value = timedelta(days=74)
        self.assertEqual(the_filter(test_value, '{seconds}'), '0')
        self.assertEqual(the_filter(test_value, '{seconds_total}'), '6393600')
        self.assertEqual(the_filter(test_value, '{seconds2}'), '00')
        self.assertEqual(the_filter(test_value, '{minutes}'), '0')
        self.assertEqual(the_filter(test_value, '{minutes_total}'), '106560')
        self.assertEqual(the_filter(test_value, '{minutes2}'), '00')
        self.assertEqual(the_filter(test_value, '{hours}'), '0')
        self.assertEqual(the_filter(test_value, '{hours_total}'), '1776')
        self.assertEqual(the_filter(test_value, '{hours2}'), '00')
        self.assertEqual(the_filter(test_value, '{days}'), '74')
        self.assertEqual(the_filter(test_value, '{days_total}'), '74')
        self.assertEqual(the_filter(test_value, '{years}'), '0')
        self.assertEqual(the_filter(test_value, '{years_total}'), '0')

    def test_years_only_10(self):
        test_value = timedelta(days=10*365)
        self.assertEqual(the_filter(test_value, '{seconds}'), '0')
        self.assertEqual(the_filter(test_value, '{seconds_total}'), '315360000')
        self.assertEqual(the_filter(test_value, '{seconds2}'), '00')
        self.assertEqual(the_filter(test_value, '{minutes}'), '0')
        self.assertEqual(the_filter(test_value, '{minutes_total}'), '5256000')
        self.assertEqual(the_filter(test_value, '{minutes2}'), '00')
        self.assertEqual(the_filter(test_value, '{hours}'), '0')
        self.assertEqual(the_filter(test_value, '{hours_total}'), '87600')
        self.assertEqual(the_filter(test_value, '{hours2}'), '00')
        self.assertEqual(the_filter(test_value, '{days}'), '0')
        self.assertEqual(the_filter(test_value, '{days_total}'), '3650')
        self.assertEqual(the_filter(test_value, '{years}'), '10')
        self.assertEqual(the_filter(test_value, '{years_total}'), '10')

    def test_random_1(self):
        test_value = timedelta(days=12345, seconds=28221)
        self.assertEqual(the_filter(test_value, '{seconds}'), '21')
        self.assertEqual(the_filter(test_value, '{seconds_total}'), '1066636221')
        self.assertEqual(the_filter(test_value, '{seconds2}'), '21')
        self.assertEqual(the_filter(test_value, '{minutes}'), '50')
        self.assertEqual(the_filter(test_value, '{minutes_total}'), '17777270')
        self.assertEqual(the_filter(test_value, '{minutes2}'), '50')
        self.assertEqual(the_filter(test_value, '{hours}'), '7')
        self.assertEqual(the_filter(test_value, '{hours_total}'), '296287')
        self.assertEqual(the_filter(test_value, '{hours2}'), '07')
        self.assertEqual(the_filter(test_value, '{days}'), '300')
        self.assertEqual(the_filter(test_value, '{days_total}'), '12345')
        self.assertEqual(the_filter(test_value, '{years}'), '33')
        self.assertEqual(the_filter(test_value, '{years_total}'), '33')

    def test_random_2(self):
        test_value = timedelta(seconds=347979675)
        self.assertEqual(the_filter(test_value, '{seconds}'), '15')
        self.assertEqual(the_filter(test_value, '{seconds_total}'), '347979675')
        self.assertEqual(the_filter(test_value, '{seconds2}'), '15')
        self.assertEqual(the_filter(test_value, '{minutes}'), '1')
        self.assertEqual(the_filter(test_value, '{minutes_total}'), '5799661')
        self.assertEqual(the_filter(test_value, '{minutes2}'), '01')
        self.assertEqual(the_filter(test_value, '{hours}'), '13')
        self.assertEqual(the_filter(test_value, '{hours_total}'), '96661')
        self.assertEqual(the_filter(test_value, '{hours2}'), '13')
        self.assertEqual(the_filter(test_value, '{days}'), '12')
        self.assertEqual(the_filter(test_value, '{days_total}'), '4027')
        self.assertEqual(the_filter(test_value, '{years}'), '11')
        self.assertEqual(the_filter(test_value, '{years_total}'), '11')

    def test_random_3(self):
        test_value = timedelta(seconds=347980455)
        self.assertEqual(the_filter(test_value, '{seconds}'), '15')
        self.assertEqual(the_filter(test_value, '{seconds_total}'), '347980455')
        self.assertEqual(the_filter(test_value, '{seconds2}'), '15')
        self.assertEqual(the_filter(test_value, '{minutes}'), '14')
        self.assertEqual(the_filter(test_value, '{minutes_total}'), '5799674')
        self.assertEqual(the_filter(test_value, '{minutes2}'), '14')
        self.assertEqual(the_filter(test_value, '{hours}'), '13')
        self.assertEqual(the_filter(test_value, '{hours_total}'), '96661')
        self.assertEqual(the_filter(test_value, '{hours2}'), '13')
        self.assertEqual(the_filter(test_value, '{days}'), '12')
        self.assertEqual(the_filter(test_value, '{days_total}'), '4027')
        self.assertEqual(the_filter(test_value, '{years}'), '11')
        self.assertEqual(the_filter(test_value, '{years_total}'), '11')
