# -*- coding: utf-8 -*-
from __future__ import unicode_literals
try:
    from django.contrib.sites.shortcuts import get_current_site
except ImportError:
    from django.contrib.sites.models import get_current_site
from django.core.exceptions import ObjectDoesNotExist
from django.db.models import get_model
from cms.utils.compat.dj import python_2_unicode_compatible


@python_2_unicode_compatible
class ImagePropertyMixin(object):
    """
    A mixin class to convert a CascadeElement into a proxy model for rendering the ``<a>`` element.
    """
    def __str__(self):
        return self.plugin_class.get_identifier(self)

    @property
    def image(self):
        if not hasattr(self, '_image_model'):
            try:
                Model = get_model(*self.glossary['image']['model'].split('.'))
                self._image_model = Model.objects.get(pk=self.glossary['image']['pk'])
            except (KeyError, ObjectDoesNotExist):
                self._image_model = None
        return self._image_model
