from cms.plugin_pool import plugin_pool
from cms.plugin_base import CMSPluginBase
from djangocms_column.models import MultiColumns, Column
from django.utils.translation import ugettext_lazy as _

class MultiColumnPlugin(CMSPluginBase):
    model = MultiColumns
    name = _("Multi Columns")
    render_template = "cms/plugins/multi_column.html"
    allow_children = True
    child_classes = ["ColumnPlugin"]

    def render(self, context, instance, placeholder):
        context.update({
            'instance': instance,
            'placeholder':placeholder,
        })
        return context


class ColumnPlugin(CMSPluginBase):
    model = Column
    name = _("Column")
    render_template = "cms/plugins/column.html"
    allow_children = True

    def render(self, context, instance, placeholder):
        context.update({
            'instance': instance,
            'placeholder':placeholder,
            })
        return context

plugin_pool.register_plugin(MultiColumnPlugin)
plugin_pool.register_plugin(ColumnPlugin)
