# -*- coding: utf-8 -*-

from appconf import AppConf

from django.conf import settings  # noqa
from django.utils.translation import ugettext_lazy as _


class DjangoCMSGmapsConf(AppConf):
    PLUGIN_MODULE = _('Generic')
    PLUGIN_NAME = _('Map')
    LOCATION_PLUGIN_NAME = _('Location')
    PAGE_ONLY = False
    PARENT_CLASSES = None
    REQUIRE_PARENT = False
    TEMPLATE = 'djangocms_gmaps/default.html'
    INFOWINDOW_TEMPLATE = 'djangocms_gmaps/infowindow.html'
    TEXT_ENABLED = False

    FIELDSETS = None
    LOCATION_FIELDSETS = None

    ADVANCED_OPTIONS_ENABLED = True
    STYLED_MAPS_ENABLED = True

    INFOWINDOW_ENABLED = True
    INFOWINDOW_MAXWIDTH = 220

    CUSTOM_MARKERS_ENABLED = True
    CUSTOM_MARKERS_WIDTH = 32
    CUSTOM_MARKERS_HEIGHT = 32

    MAP_TYPES = (
        ('ROADMAP', _('ROADMAP (normal, default 2D map)')),
        ('SATELLITE', _('SATELLITE (photographic map)')),
        ('HYBRID', _('HYBRID (photographic map + roads and city names)')),
        ('TERRAIN', _('TERRAIN (map with mountains, rivers, etc.')),
    )

    MAP_TYPES_DEFAULT = 'ROADMAP'

    ## Nicely titled (and translatable) country names.
    COUNTRIES = (
        ('AF', _(u'Afghanistan')),
        ('AX', _(u'Åland Islands')),
        ('AL', _(u'Albania')),
        ('DZ', _(u'Algeria')),
        ('AS', _(u'American Samoa')),
        ('AD', _(u'Andorra')),
        ('AO', _(u'Angola')),
        ('AI', _(u'Anguilla')),
        ('AQ', _(u'Antarctica')),
        ('AG', _(u'Antigua and Barbuda')),
        ('AR', _(u'Argentina')),
        ('AM', _(u'Armenia')),
        ('AW', _(u'Aruba')),
        ('AU', _(u'Australia')),
        ('AT', _(u'Austria')),
        ('AZ', _(u'Azerbaijan')),
        ('BS', _(u'Bahamas')),
        ('BH', _(u'Bahrain')),
        ('BD', _(u'Bangladesh')),
        ('BB', _(u'Barbados')),
        ('BY', _(u'Belarus')),
        ('BE', _(u'Belgium')),
        ('BZ', _(u'Belize')),
        ('BJ', _(u'Benin')),
        ('BM', _(u'Bermuda')),
        ('BT', _(u'Bhutan')),
        ('BO', _(u'Bolivia, Plurinational State of')),
        ('BQ', _(u'Bonaire, Sint Eustatius and Saba')),
        ('BA', _(u'Bosnia and Herzegovina')),
        ('BW', _(u'Botswana')),
        ('BV', _(u'Bouvet Island')),
        ('BR', _(u'Brazil')),
        ('IO', _(u'British Indian Ocean Territory')),
        ('BN', _(u'Brunei Darussalam')),
        ('BG', _(u'Bulgaria')),
        ('BF', _(u'Burkina Faso')),
        ('BI', _(u'Burundi')),
        ('KH', _(u'Cambodia')),
        ('CM', _(u'Cameroon')),
        ('CA', _(u'Canada')),
        ('CV', _(u'Cape Verde')),
        ('KY', _(u'Cayman Islands')),
        ('CF', _(u'Central African Republic')),
        ('TD', _(u'Chad')),
        ('CL', _(u'Chile')),
        ('CN', _(u'China')),
        ('CX', _(u'Christmas Island')),
        ('CC', _(u'Cocos (Keeling) Islands')),
        ('CO', _(u'Colombia')),
        ('KM', _(u'Comoros')),
        ('CG', _(u'Congo')),
        ('CD', _(u'Congo (the Democratic Republic of the)')),
        ('CK', _(u'Cook Islands')),
        ('CR', _(u'Costa Rica')),
        ('CI', _(u'Côte d\'Ivoire')),
        ('HR', _(u'Croatia')),
        ('CU', _(u'Cuba')),
        ('CW', _(u'Curaçao')),
        ('CY', _(u'Cyprus')),
        ('CZ', _(u'Czech Republic')),
        ('DK', _(u'Denmark')),
        ('DJ', _(u'Djibouti')),
        ('DM', _(u'Dominica')),
        ('DO', _(u'Dominican Republic')),
        ('EC', _(u'Ecuador')),
        ('EG', _(u'Egypt')),
        ('SV', _(u'El Salvador')),
        ('GQ', _(u'Equatorial Guinea')),
        ('ER', _(u'Eritrea')),
        ('EE', _(u'Estonia')),
        ('ET', _(u'Ethiopia')),
        ('FK', _(u'Falkland Islands  [Malvinas]')),
        ('FO', _(u'Faroe Islands')),
        ('FJ', _(u'Fiji')),
        ('FI', _(u'Finland')),
        ('FR', _(u'France')),
        ('GF', _(u'French Guiana')),
        ('PF', _(u'French Polynesia')),
        ('TF', _(u'French Southern Territories')),
        ('GA', _(u'Gabon')),
        ('GM', _(u'Gambia (The)')),
        ('GE', _(u'Georgia')),
        ('DE', _(u'Germany')),
        ('GH', _(u'Ghana')),
        ('GI', _(u'Gibraltar')),
        ('GR', _(u'Greece')),
        ('GL', _(u'Greenland')),
        ('GD', _(u'Grenada')),
        ('GP', _(u'Guadeloupe')),
        ('GU', _(u'Guam')),
        ('GT', _(u'Guatemala')),
        ('GG', _(u'Guernsey')),
        ('GN', _(u'Guinea')),
        ('GW', _(u'Guinea-Bissau')),
        ('GY', _(u'Guyana')),
        ('HT', _(u'Haiti')),
        ('HM', _(u'Heard Island and McDonald Islands')),
        ('VA', _(u'Holy See  [Vatican City State]')),
        ('HN', _(u'Honduras')),
        ('HK', _(u'Hong Kong')),
        ('HU', _(u'Hungary')),
        ('IS', _(u'Iceland')),
        ('IN', _(u'India')),
        ('ID', _(u'Indonesia')),
        ('IR', _(u'Iran (the Islamic Republic of)')),
        ('IQ', _(u'Iraq')),
        ('IE', _(u'Ireland')),
        ('IM', _(u'Isle of Man')),
        ('IL', _(u'Israel')),
        ('IT', _(u'Italy')),
        ('JM', _(u'Jamaica')),
        ('JP', _(u'Japan')),
        ('JE', _(u'Jersey')),
        ('JO', _(u'Jordan')),
        ('KZ', _(u'Kazakhstan')),
        ('KE', _(u'Kenya')),
        ('KI', _(u'Kiribati')),
        ('KP', _(u'Korea (the Democratic People\'s Republic of)')),
        ('KR', _(u'Korea (the Republic of)')),
        ('KW', _(u'Kuwait')),
        ('KG', _(u'Kyrgyzstan')),
        ('LA', _(u'Lao People\'s Democratic Republic')),
        ('LV', _(u'Latvia')),
        ('LB', _(u'Lebanon')),
        ('LS', _(u'Lesotho')),
        ('LR', _(u'Liberia')),
        ('LY', _(u'Libya')),
        ('LI', _(u'Liechtenstein')),
        ('LT', _(u'Lithuania')),
        ('LU', _(u'Luxembourg')),
        ('MO', _(u'Macao')),
        ('MK', _(u'Macedonia (the former Yugoslav Republic of)')),
        ('MG', _(u'Madagascar')),
        ('MW', _(u'Malawi')),
        ('MY', _(u'Malaysia')),
        ('MV', _(u'Maldives')),
        ('ML', _(u'Mali')),
        ('MT', _(u'Malta')),
        ('MH', _(u'Marshall Islands')),
        ('MQ', _(u'Martinique')),
        ('MR', _(u'Mauritania')),
        ('MU', _(u'Mauritius')),
        ('YT', _(u'Mayotte')),
        ('MX', _(u'Mexico')),
        ('FM', _(u'Micronesia (the Federated States of)')),
        ('MD', _(u'Moldova (the Republic of)')),
        ('MC', _(u'Monaco')),
        ('MN', _(u'Mongolia')),
        ('ME', _(u'Montenegro')),
        ('MS', _(u'Montserrat')),
        ('MA', _(u'Morocco')),
        ('MZ', _(u'Mozambique')),
        ('MM', _(u'Myanmar')),
        ('NA', _(u'Namibia')),
        ('NR', _(u'Nauru')),
        ('NP', _(u'Nepal')),
        ('NL', _(u'Netherlands')),
        ('NC', _(u'New Caledonia')),
        ('NZ', _(u'New Zealand')),
        ('NI', _(u'Nicaragua')),
        ('NE', _(u'Niger')),
        ('NG', _(u'Nigeria')),
        ('NU', _(u'Niue')),
        ('NF', _(u'Norfolk Island')),
        ('MP', _(u'Northern Mariana Islands')),
        ('NO', _(u'Norway')),
        ('OM', _(u'Oman')),
        ('PK', _(u'Pakistan')),
        ('PW', _(u'Palau')),
        ('PS', _(u'Palestine, State of')),
        ('PA', _(u'Panama')),
        ('PG', _(u'Papua New Guinea')),
        ('PY', _(u'Paraguay')),
        ('PE', _(u'Peru')),
        ('PH', _(u'Philippines')),
        ('PN', _(u'Pitcairn')),
        ('PL', _(u'Poland')),
        ('PT', _(u'Portugal')),
        ('PR', _(u'Puerto Rico')),
        ('QA', _(u'Qatar')),
        ('RE', _(u'Réunion')),
        ('RO', _(u'Romania')),
        ('RU', _(u'Russian Federation')),
        ('RW', _(u'Rwanda')),
        ('BL', _(u'Saint Barthélemy')),
        ('SH', _(u'Saint Helena, Ascension and Tristan da Cunha')),
        ('KN', _(u'Saint Kitts and Nevis')),
        ('LC', _(u'Saint Lucia')),
        ('MF', _(u'Saint Martin (French part)')),
        ('PM', _(u'Saint Pierre and Miquelon')),
        ('VC', _(u'Saint Vincent and the Grenadines')),
        ('WS', _(u'Samoa')),
        ('SM', _(u'San Marino')),
        ('ST', _(u'Sao Tome and Principe')),
        ('SA', _(u'Saudi Arabia')),
        ('SN', _(u'Senegal')),
        ('RS', _(u'Serbia')),
        ('SC', _(u'Seychelles')),
        ('SL', _(u'Sierra Leone')),
        ('SG', _(u'Singapore')),
        ('SX', _(u'Sint Maarten (Dutch part)')),
        ('SK', _(u'Slovakia')),
        ('SI', _(u'Slovenia')),
        ('SB', _(u'Solomon Islands')),
        ('SO', _(u'Somalia')),
        ('ZA', _(u'South Africa')),
        ('GS', _(u'South Georgia and the South Sandwich Islands')),
        ('SS', _(u'South Sudan')),
        ('ES', _(u'Spain')),
        ('LK', _(u'Sri Lanka')),
        ('SD', _(u'Sudan')),
        ('SR', _(u'Suriname')),
        ('SJ', _(u'Svalbard and Jan Mayen')),
        ('SZ', _(u'Swaziland')),
        ('SE', _(u'Sweden')),
        ('CH', _(u'Switzerland')),
        ('SY', _(u'Syrian Arab Republic')),
        ('TW', _(u'Taiwan (Province of China)')),
        ('TJ', _(u'Tajikistan')),
        ('TZ', _(u'Tanzania, United Republic of')),
        ('TH', _(u'Thailand')),
        ('TL', _(u'Timor-Leste')),
        ('TG', _(u'Togo')),
        ('TK', _(u'Tokelau')),
        ('TO', _(u'Tonga')),
        ('TT', _(u'Trinidad and Tobago')),
        ('TN', _(u'Tunisia')),
        ('TR', _(u'Turkey')),
        ('TM', _(u'Turkmenistan')),
        ('TC', _(u'Turks and Caicos Islands')),
        ('TV', _(u'Tuvalu')),
        ('UG', _(u'Uganda')),
        ('UA', _(u'Ukraine')),
        ('AE', _(u'United Arab Emirates')),
        ('GB', _(u'United Kingdom')),
        ('US', _(u'United States')),
        ('UM', _(u'United States Minor Outlying Islands')),
        ('UY', _(u'Uruguay')),
        ('UZ', _(u'Uzbekistan')),
        ('VU', _(u'Vanuatu')),
        ('VE', _(u'Venezuela, Bolivarian Republic of')),
        ('VN', _(u'Vietnam')),
        ('VG', _(u'Virgin Islands (British)')),
        ('VI', _(u'Virgin Islands (U.S.)')),
        ('WF', _(u'Wallis and Futuna')),
        ('EH', _(u'Western Sahara')),
        ('YE', _(u'Yemen')),
        ('ZM', _(u'Zambia')),
        ('ZW', _(u'Zimbabwe')),
    )

    class Meta:
        prefix = 'djangocms_gmaps'
