# -*- coding: utf-8 -*-
from django.db import models
from django.utils.translation import ugettext_lazy as _

from cms.models.pluginmodel import CMSPlugin
from cms.models.fields import PageField
from tinymce.models import HTMLField
from filer.fields.image import FilerImageField
import djangocms_simple_gallery.south_introspections

from djangocms_simple_gallery import settings
from djangocms_simple_gallery.validators import fancy_url_validator

import math


class Gallery(CMSPlugin):
    title = models.CharField(_('title'), max_length=100, blank=True, null=True)
    template = models.CharField(_('template'), max_length=255, default=settings.GALLERY_TEMPLATES[0][0],
        choices=settings.GALLERY_TEMPLATES)
    autoplay = models.PositiveIntegerField(_('autoplay'), default=0, blank=True,
        help_text=_('Time in seconds each slide is displayed. Zero means no autoplay.'))

    # Advanced
    duration = models.PositiveIntegerField(_('duration'), default=0, blank=True,
        help_text=_('Duration of the animation in seconds. Zero means no animation.'))

    def __unicode__(self):
        if self.title:
            return self.title
        return super(Gallery, self).__unicode__()

    def copy_relations(self, old_instance):
        for slide in old_instance.slides.all():
            slide.pk = None
            slide.gallery = self.pk
            slide.save()


class Slide(models.Model):
    gallery = models.ForeignKey(Gallery, related_name='slides')
    ordering = models.IntegerField(_('ordering'), default=100)
    image = FilerImageField(verbose_name=_('image'))

    title = models.CharField(_('title'), max_length=100, blank=True, null=True)
    description = HTMLField(_('description'), blank=True, null=True)
    page = PageField(verbose_name=_('page'), blank=True, null=True)
    url = models.CharField(_('url'), max_length=255, blank=True, null=True, validators=[fancy_url_validator])

    class Meta:
        ordering = ['ordering', 'pk',]

    def __unicode__(self):
        return self.get_title

    @property
    def get_title(self):
        if self.title:
            return self.title
        return self.image.label

    @property
    def link(self):
        if self.page:
            return self.page.get_absolute_url()
        if self.url:
            return self.url
        return '#'

    @property
    def has_link(self):
        if self.page or self.url:
            return True
        return False