# Entries are dictionary objects with
# name: string, arbitrary
# category: string, will be used to match StagingTable objects as inputs
#       for integration
# ds_family_abbr: string, will be used to match
#       StagingTable.data_source.parent.abbreviation for inputs
# ds_parent_abbr: string, will be used to match
#       StagingTable.data_source.parent.abbreviation for inputs
# columns: list, each member must be dict with
#               field: string, will match column names for inputs
#                       TODO: extend this to support lists, for
#                               many-to-one situations, condensing cols
#               type: string, must be a PostgreSQL column data type

DEFAULT_DEFINITIONS = [
    {
        'name': 'SID Standard Universe',
        'category': 'CORE_PROCESSED',
        'ds_family_abbr': 'SID', 
        'ds_parent_abbr': 'HCUP', # the parent of the real Definition.data_source
        'columns': [
            {'field': 'KEY', 'type': 'BIGINT'},
            {'field': 'STATE', 'type': 'VARCHAR'},
            {'field': 'YEAR', 'type': 'INT'},
            {'field': 'VISITLINK', 'type': 'BIGINT'},
            {'field': 'ZIP', 'type': 'VARCHAR'},
            {'field': 'ZIP3', 'type': 'VARCHAR'},
            {'field': 'DAYSTOEVENT', 'type': 'INT'},
            {'field': 'RACE', 'type': 'INT'},
            {'field': 'FEMALE', 'type': 'INT'},
            {'field': 'AGE', 'type': 'INT'},
            {'field': 'AGEDAY', 'type': 'INT'},
            {'field': 'AGEMONTH', 'type': 'INT'},
            {'field': 'PAY1', 'type': 'INT'},
            {'field': 'PAY2', 'type': 'INT'},
            {'field': 'DISPUB04', 'type': 'INT'},
            {'field': 'DISPUB92', 'type': 'INT'},
            {'field': 'ASOURCE', 'type': 'INT'},
            {'field': 'AMONTH', 'type': 'INT'},
            {'field': 'DRG', 'type': 'VARCHAR'},
            {'field': 'DIED', 'type': 'INT'},
            {'field': 'LOS', 'type': 'INT'},
            {'field': 'ahaid', 'type': 'VARCHAR'},
            {'field': 'hospid', 'type': 'INT'},
            {'field': 'hospstco', 'type': 'INT'},
            {'field': 'cm_aids', 'type': 'INT'},
            {'field': 'cm_alcohol', 'type': 'INT'},
            {'field': 'cm_anemdef', 'type': 'INT'},
            {'field': 'cm_arth', 'type': 'INT'},
            {'field': 'cm_bldloss', 'type': 'INT'},
            {'field': 'cm_chf', 'type': 'INT'},
            {'field': 'cm_chrnlung', 'type': 'INT'},
            {'field': 'cm_coag', 'type': 'INT'},
            {'field': 'cm_depress', 'type': 'INT'},
            {'field': 'cm_dm', 'type': 'INT'},
            {'field': 'cm_dmcx', 'type': 'INT'},
            {'field': 'cm_drug', 'type': 'INT'},
            {'field': 'cm_htn_c', 'type': 'INT'},
            {'field': 'cm_hypothy', 'type': 'INT'},
            {'field': 'cm_liver', 'type': 'INT'},
            {'field': 'cm_lymph', 'type': 'INT'},
            {'field': 'cm_lytes', 'type': 'INT'},
            {'field': 'cm_mets', 'type': 'INT'},
            {'field': 'cm_neuro', 'type': 'INT'},
            {'field': 'cm_obese', 'type': 'INT'},
            {'field': 'cm_para', 'type': 'INT'},
            {'field': 'cm_perivasc', 'type': 'INT'},
            {'field': 'cm_psych', 'type': 'INT'},
            {'field': 'cm_pulmcirc', 'type': 'INT'},
            {'field': 'cm_renlfail', 'type': 'INT'},
            {'field': 'cm_tumor', 'type': 'INT'},
            {'field': 'cm_ulcer', 'type': 'INT'},
            {'field': 'cm_valve', 'type': 'INT'},
            {'field': 'cm_wghtloss', 'type': 'INT'},
            {'field': 'chron1', 'type': 'INT'},
            {'field': 'chron2', 'type': 'INT'},
            {'field': 'chron3', 'type': 'INT'},
            {'field': 'chron4', 'type': 'INT'},
            {'field': 'chron5', 'type': 'INT'},
            {'field': 'chron6', 'type': 'INT'},
            {'field': 'chron7', 'type': 'INT'},
            {'field': 'chron8', 'type': 'INT'},
            {'field': 'chron9', 'type': 'INT'},
            {'field': 'chron10', 'type': 'INT'},
            {'field': 'chron11', 'type': 'INT'},
            {'field': 'chron12', 'type': 'INT'},
            {'field': 'chron13', 'type': 'INT'},
            {'field': 'chron14', 'type': 'INT'},
            {'field': 'chron15', 'type': 'INT'},
            {'field': 'chron16', 'type': 'INT'},
            {'field': 'chron17', 'type': 'INT'},
            {'field': 'chron18', 'type': 'INT'},
            {'field': 'chron19', 'type': 'INT'},
            {'field': 'chron20', 'type': 'INT'},
            {'field': 'chron21', 'type': 'INT'},
            {'field': 'chron22', 'type': 'INT'},
            {'field': 'chron23', 'type': 'INT'},
            {'field': 'chron24', 'type': 'INT'},
            {'field': 'chron25', 'type': 'INT'},
            {'field': 'chronb1', 'type': 'INT'},
            {'field': 'chronb2', 'type': 'INT'},
            {'field': 'chronb3', 'type': 'INT'},
            {'field': 'chronb4', 'type': 'INT'},
            {'field': 'chronb5', 'type': 'INT'},
            {'field': 'chronb6', 'type': 'INT'},
            {'field': 'chronb7', 'type': 'INT'},
            {'field': 'chronb8', 'type': 'INT'},
            {'field': 'chronb9', 'type': 'INT'},
            {'field': 'chronb10', 'type': 'INT'},
            {'field': 'chronb11', 'type': 'INT'},
            {'field': 'chronb12', 'type': 'INT'},
            {'field': 'chronb13', 'type': 'INT'},
            {'field': 'chronb14', 'type': 'INT'},
            {'field': 'chronb15', 'type': 'INT'},
            {'field': 'chronb16', 'type': 'INT'},
            {'field': 'chronb17', 'type': 'INT'},
            {'field': 'chronb18', 'type': 'INT'},
            {'field': 'chronb19', 'type': 'INT'},
            {'field': 'chronb20', 'type': 'INT'},
            {'field': 'chronb21', 'type': 'INT'},
            {'field': 'chronb22', 'type': 'INT'},
            {'field': 'chronb23', 'type': 'INT'},
            {'field': 'chronb24', 'type': 'INT'},
            {'field': 'chronb25', 'type': 'INT'},
            {'field': 'dxmccs1', 'type': 'VARCHAR'},
            {'field': 'dxmccs2', 'type': 'VARCHAR'},
            {'field': 'dxmccs3', 'type': 'VARCHAR'},
            {'field': 'dxmccs4', 'type': 'VARCHAR'},
            {'field': 'dxmccs5', 'type': 'VARCHAR'},
            {'field': 'dxmccs6', 'type': 'VARCHAR'},
            {'field': 'dxmccs7', 'type': 'VARCHAR'},
            {'field': 'dxmccs8', 'type': 'VARCHAR'},
            {'field': 'dxmccs9', 'type': 'VARCHAR'},
            {'field': 'dxmccs10', 'type': 'VARCHAR'},
            {'field': 'dxmccs11', 'type': 'VARCHAR'},
            {'field': 'dxmccs12', 'type': 'VARCHAR'},
            {'field': 'dxmccs13', 'type': 'VARCHAR'},
            {'field': 'dxmccs14', 'type': 'VARCHAR'},
            {'field': 'dxmccs15', 'type': 'VARCHAR'},
            {'field': 'dxmccs16', 'type': 'VARCHAR'},
            {'field': 'dxmccs17', 'type': 'VARCHAR'},
            {'field': 'dxmccs18', 'type': 'VARCHAR'},
            {'field': 'dxmccs19', 'type': 'VARCHAR'},
            {'field': 'dxmccs20', 'type': 'VARCHAR'},
            {'field': 'dxmccs21', 'type': 'VARCHAR'},
            {'field': 'dxmccs22', 'type': 'VARCHAR'},
            {'field': 'dxmccs23', 'type': 'VARCHAR'},
            {'field': 'dxmccs24', 'type': 'VARCHAR'},
            {'field': 'dxmccs25', 'type': 'VARCHAR'},
            {'field': 'ccsmgn1', 'type': 'INT'},
            {'field': 'ccsmgn2', 'type': 'INT'},
            {'field': 'ccsmgn3', 'type': 'INT'},
            {'field': 'ccsmgn4', 'type': 'INT'},
            {'field': 'ccsmgn5', 'type': 'INT'},
            {'field': 'ccsmgn6', 'type': 'INT'},
            {'field': 'ccsmgn7', 'type': 'INT'},
            {'field': 'ccsmgn8', 'type': 'INT'},
            {'field': 'ccsmgn9', 'type': 'INT'},
            {'field': 'ccsmsp1', 'type': 'INT'},
            {'field': 'ccsmsp2', 'type': 'INT'},
            {'field': 'ccsmsp3', 'type': 'INT'},
            {'field': 'ccsmsp4', 'type': 'INT'},
            {'field': 'ccsmsp5', 'type': 'INT'},
            {'field': 'ccsmsp6', 'type': 'INT'},
            {'field': 'ccsmsp7', 'type': 'INT'},
            {'field': 'ccsmsp8', 'type': 'INT'},
            {'field': 'ccsmsp9', 'type': 'INT'},
            {'field': 'eccsmgn1', 'type': 'INT'},
            {'field': 'eccsmgn2', 'type': 'INT'},
            {'field': 'eccsmgn3', 'type': 'INT'},
            {'field': 'eccsmgn4', 'type': 'INT'},
            {'field': 'eccsmgn5', 'type': 'INT'},
            {'field': 'e_mccs1', 'type': 'VARCHAR'},
            {'field': 'e_mccs2', 'type': 'VARCHAR'},
            {'field': 'e_mccs3', 'type': 'VARCHAR'},
            {'field': 'e_mccs4', 'type': 'VARCHAR'},
            {'field': 'e_mccs5', 'type': 'VARCHAR'},
            {'field': 'e_mccs6', 'type': 'VARCHAR'},
            {'field': 'pclass1', 'type': 'INT'},
            {'field': 'pclass2', 'type': 'INT'},
            {'field': 'pclass3', 'type': 'INT'},
            {'field': 'pclass4', 'type': 'INT'},
            {'field': 'pclass5', 'type': 'INT'},
            {'field': 'pclass6', 'type': 'INT'},
            {'field': 'pclass7', 'type': 'INT'},
            {'field': 'pclass8', 'type': 'INT'},
            {'field': 'pclass9', 'type': 'INT'},
            {'field': 'pclass10', 'type': 'INT'},
            {'field': 'pclass11', 'type': 'INT'},
            {'field': 'pclass12', 'type': 'INT'},
            {'field': 'prmccs1', 'type': 'VARCHAR'},
            {'field': 'prmccs2', 'type': 'VARCHAR'},
            {'field': 'prmccs3', 'type': 'VARCHAR'},
            {'field': 'prmccs4', 'type': 'VARCHAR'},
            {'field': 'prmccs5', 'type': 'VARCHAR'},
            {'field': 'prmccs6', 'type': 'VARCHAR'},
            {'field': 'prmccs7', 'type': 'VARCHAR'},
            {'field': 'prmccs8', 'type': 'VARCHAR'},
            {'field': 'prmccs9', 'type': 'VARCHAR'},
            {'field': 'prmccs10', 'type': 'VARCHAR'},
            {'field': 'prmccs11', 'type': 'VARCHAR'},
            {'field': 'prmccs12', 'type': 'VARCHAR'},
            {'field': 'u_icu', 'type': 'INT'},
            {'field': 'u_ccu', 'type': 'INT'},
            {'field': 'u_newbn2l', 'type': 'INT'},
            {'field': 'u_newbn3l', 'type': 'INT'},
            {'field': 'u_newbn4l', 'type': 'INT'},
            {'field': 'u_cath', 'type': 'INT'},
            {'field': 'u_stress', 'type': 'INT'},
            {'field': 'u_echo', 'type': 'INT'},
            {'field': 'u_ekg', 'type': 'INT'},
            {'field': 'u_ctscan', 'type': 'INT'},
            {'field': 'u_chestxray', 'type': 'INT'},
            {'field': 'u_ultrasound', 'type': 'INT'},
            {'field': 'u_eeg', 'type': 'INT'},
            {'field': 'u_nucmed', 'type': 'INT'},
            {'field': 'u_mrt', 'type': 'INT'},
            {'field': 'u_pacemaker', 'type': 'INT'},
            {'field': 'u_othimplants', 'type': 'INT'},
            {'field': 'u_lithotripsy', 'type': 'INT'},
            {'field': 'u_occtherapy', 'type': 'INT'},
            {'field': 'u_phytherapy', 'type': 'INT'},
            {'field': 'u_radtherapy', 'type': 'INT'},
            {'field': 'u_resptherapy', 'type': 'INT'},
            {'field': 'u_speechtherapy', 'type': 'INT'},
            {'field': 'u_blood', 'type': 'INT'},
            {'field': 'u_dialysis', 'type': 'INT'},
            {'field': 'u_epo', 'type': 'INT'},
            {'field': 'u_mhsa', 'type': 'INT'},
            {'field': 'u_ed', 'type': 'INT'},
            {'field': 'u_observation', 'type': 'INT'},
            {'field': 'u_organacq', 'type': 'INT'},
            {'field': 'pr1', 'type': 'VARCHAR'},
            {'field': 'pr2', 'type': 'VARCHAR'},
            {'field': 'pr3', 'type': 'VARCHAR'},
            {'field': 'pr4', 'type': 'VARCHAR'},
            {'field': 'pr5', 'type': 'VARCHAR'},
            {'field': 'pr6', 'type': 'VARCHAR'},
            {'field': 'pr7', 'type': 'VARCHAR'},
            {'field': 'pr8', 'type': 'VARCHAR'},
            {'field': 'pr9', 'type': 'VARCHAR'},
            {'field': 'pr10', 'type': 'VARCHAR'},
            {'field': 'pr11', 'type': 'VARCHAR'},
            {'field': 'pr12', 'type': 'VARCHAR'},
            {'field': 'pr13', 'type': 'VARCHAR'},
            {'field': 'pr14', 'type': 'VARCHAR'},
            {'field': 'pr15', 'type': 'VARCHAR'},
            {'field': 'pr16', 'type': 'VARCHAR'},
            {'field': 'pr17', 'type': 'VARCHAR'},
            {'field': 'pr18', 'type': 'VARCHAR'},
            {'field': 'pr19', 'type': 'VARCHAR'},
            {'field': 'pr20', 'type': 'VARCHAR'},
            {'field': 'pr21', 'type': 'VARCHAR'},
            {'field': 'pr22', 'type': 'VARCHAR'},
            {'field': 'pr23', 'type': 'VARCHAR'},
            {'field': 'pr24', 'type': 'VARCHAR'},
            {'field': 'pr25', 'type': 'VARCHAR'},
            {'field': 'pryear1', 'type': 'INT'},
            {'field': 'pryear2', 'type': 'INT'},
            {'field': 'pryear3', 'type': 'INT'},
            {'field': 'pryear4', 'type': 'INT'},
            {'field': 'pryear5', 'type': 'INT'},
            {'field': 'pryear6', 'type': 'INT'},
            {'field': 'pryear7', 'type': 'INT'},
            {'field': 'pryear8', 'type': 'INT'},
            {'field': 'pryear9', 'type': 'INT'},
            {'field': 'pryear10', 'type': 'INT'},
            {'field': 'pryear11', 'type': 'INT'},
            {'field': 'pryear12', 'type': 'INT'},
            {'field': 'pryear13', 'type': 'INT'},
            {'field': 'pryear14', 'type': 'INT'},
            {'field': 'pryear15', 'type': 'INT'},
            {'field': 'pryear16', 'type': 'INT'},
            {'field': 'pryear17', 'type': 'INT'},
            {'field': 'pryear18', 'type': 'INT'},
            {'field': 'pryear19', 'type': 'INT'},
            {'field': 'pryear20', 'type': 'INT'},
            {'field': 'pryear21', 'type': 'INT'},
            {'field': 'pryear22', 'type': 'INT'},
            {'field': 'pryear23', 'type': 'INT'},
            {'field': 'pryear24', 'type': 'INT'},
            {'field': 'pryear25', 'type': 'INT'},
            {'field': 'prmonth1', 'type': 'INT'},
            {'field': 'prmonth2', 'type': 'INT'},
            {'field': 'prmonth3', 'type': 'INT'},
            {'field': 'prmonth4', 'type': 'INT'},
            {'field': 'prmonth5', 'type': 'INT'},
            {'field': 'prmonth6', 'type': 'INT'},
            {'field': 'prmonth7', 'type': 'INT'},
            {'field': 'prmonth8', 'type': 'INT'},
            {'field': 'prmonth9', 'type': 'INT'},
            {'field': 'prmonth10', 'type': 'INT'},
            {'field': 'prmonth11', 'type': 'INT'},
            {'field': 'prmonth12', 'type': 'INT'},
            {'field': 'prmonth13', 'type': 'INT'},
            {'field': 'prmonth14', 'type': 'INT'},
            {'field': 'prmonth15', 'type': 'INT'},
            {'field': 'prmonth16', 'type': 'INT'},
            {'field': 'prmonth17', 'type': 'INT'},
            {'field': 'prmonth18', 'type': 'INT'},
            {'field': 'prmonth19', 'type': 'INT'},
            {'field': 'prmonth20', 'type': 'INT'},
            {'field': 'prmonth21', 'type': 'INT'},
            {'field': 'prmonth22', 'type': 'INT'},
            {'field': 'prmonth23', 'type': 'INT'},
            {'field': 'prmonth24', 'type': 'INT'},
            {'field': 'prmonth25', 'type': 'INT'},
            {'field': 'prday1', 'type': 'INT'},
            {'field': 'prday2', 'type': 'INT'},
            {'field': 'prday3', 'type': 'INT'},
            {'field': 'prday4', 'type': 'INT'},
            {'field': 'prday5', 'type': 'INT'},
            {'field': 'prday6', 'type': 'INT'},
            {'field': 'prday7', 'type': 'INT'},
            {'field': 'prday8', 'type': 'INT'},
            {'field': 'prday9', 'type': 'INT'},
            {'field': 'prday10', 'type': 'INT'},
            {'field': 'prday11', 'type': 'INT'},
            {'field': 'prday12', 'type': 'INT'},
            {'field': 'prday13', 'type': 'INT'},
            {'field': 'prday14', 'type': 'INT'},
            {'field': 'prday15', 'type': 'INT'},
            {'field': 'prday16', 'type': 'INT'},
            {'field': 'prday17', 'type': 'INT'},
            {'field': 'prday18', 'type': 'INT'},
            {'field': 'prday19', 'type': 'INT'},
            {'field': 'prday20', 'type': 'INT'},
            {'field': 'prday21', 'type': 'INT'},
            {'field': 'prday22', 'type': 'INT'},
            {'field': 'prday23', 'type': 'INT'},
            {'field': 'prday24', 'type': 'INT'},
            {'field': 'prday25', 'type': 'INT'},
            {'field': 'prccs1', 'type': 'VARCHAR'},
            {'field': 'prccs2', 'type': 'VARCHAR'},
            {'field': 'prccs3', 'type': 'VARCHAR'},
            {'field': 'prccs4', 'type': 'VARCHAR'},
            {'field': 'prccs5', 'type': 'VARCHAR'},
            {'field': 'prccs6', 'type': 'VARCHAR'},
            {'field': 'prccs7', 'type': 'VARCHAR'},
            {'field': 'prccs8', 'type': 'VARCHAR'},
            {'field': 'prccs9', 'type': 'VARCHAR'},
            {'field': 'prccs10', 'type': 'VARCHAR'},
            {'field': 'prccs11', 'type': 'VARCHAR'},
            {'field': 'prccs12', 'type': 'VARCHAR'},
            {'field': 'prccs13', 'type': 'VARCHAR'},
            {'field': 'prccs14', 'type': 'VARCHAR'},
            {'field': 'prccs15', 'type': 'VARCHAR'},
            {'field': 'prccs16', 'type': 'VARCHAR'},
            {'field': 'prccs17', 'type': 'VARCHAR'},
            {'field': 'prccs18', 'type': 'VARCHAR'},
            {'field': 'prccs19', 'type': 'VARCHAR'},
            {'field': 'prccs20', 'type': 'VARCHAR'},
            {'field': 'prccs21', 'type': 'VARCHAR'},
            {'field': 'prccs22', 'type': 'VARCHAR'},
            {'field': 'prccs23', 'type': 'VARCHAR'},
            {'field': 'prccs24', 'type': 'VARCHAR'},
            {'field': 'prccs25', 'type': 'VARCHAR'},
            {'field': 'dx1', 'type': 'VARCHAR'},
            {'field': 'dx2', 'type': 'VARCHAR'},
            {'field': 'dx3', 'type': 'VARCHAR'},
            {'field': 'dx4', 'type': 'VARCHAR'},
            {'field': 'dx5', 'type': 'VARCHAR'},
            {'field': 'dx6', 'type': 'VARCHAR'},
            {'field': 'dx7', 'type': 'VARCHAR'},
            {'field': 'dx8', 'type': 'VARCHAR'},
            {'field': 'dx9', 'type': 'VARCHAR'},
            {'field': 'dx10', 'type': 'VARCHAR'},
            {'field': 'dx11', 'type': 'VARCHAR'},
            {'field': 'dx12', 'type': 'VARCHAR'},
            {'field': 'dx13', 'type': 'VARCHAR'},
            {'field': 'dx14', 'type': 'VARCHAR'},
            {'field': 'dx15', 'type': 'VARCHAR'},
            {'field': 'dx16', 'type': 'VARCHAR'},
            {'field': 'dx17', 'type': 'VARCHAR'},
            {'field': 'dx18', 'type': 'VARCHAR'},
            {'field': 'dx19', 'type': 'VARCHAR'},
            {'field': 'dx20', 'type': 'VARCHAR'},
            {'field': 'dx21', 'type': 'VARCHAR'},
            {'field': 'dx22', 'type': 'VARCHAR'},
            {'field': 'dx23', 'type': 'VARCHAR'},
            {'field': 'dx24', 'type': 'VARCHAR'},
            {'field': 'dx25', 'type': 'VARCHAR'},
            {'field': 'dxpoa1', 'type': 'VARCHAR'},
            {'field': 'dxpoa2', 'type': 'VARCHAR'},
            {'field': 'dxpoa3', 'type': 'VARCHAR'},
            {'field': 'dxpoa4', 'type': 'VARCHAR'},
            {'field': 'dxpoa5', 'type': 'VARCHAR'},
            {'field': 'dxpoa6', 'type': 'VARCHAR'},
            {'field': 'dxpoa7', 'type': 'VARCHAR'},
            {'field': 'dxpoa8', 'type': 'VARCHAR'},
            {'field': 'dxpoa9', 'type': 'VARCHAR'},
            {'field': 'dxpoa10', 'type': 'VARCHAR'},
            {'field': 'dxpoa11', 'type': 'VARCHAR'},
            {'field': 'dxpoa12', 'type': 'VARCHAR'},
            {'field': 'dxpoa13', 'type': 'VARCHAR'},
            {'field': 'dxpoa14', 'type': 'VARCHAR'},
            {'field': 'dxpoa15', 'type': 'VARCHAR'},
            {'field': 'dxpoa16', 'type': 'VARCHAR'},
            {'field': 'dxpoa17', 'type': 'VARCHAR'},
            {'field': 'dxpoa18', 'type': 'VARCHAR'},
            {'field': 'dxpoa19', 'type': 'VARCHAR'},
            {'field': 'dxpoa20', 'type': 'VARCHAR'},
            {'field': 'dxpoa21', 'type': 'VARCHAR'},
            {'field': 'dxpoa22', 'type': 'VARCHAR'},
            {'field': 'dxpoa23', 'type': 'VARCHAR'},
            {'field': 'dxpoa24', 'type': 'VARCHAR'},
            {'field': 'dxpoa25', 'type': 'VARCHAR'},
            {'field': 'dxccs1', 'type': 'VARCHAR'},
            {'field': 'dxccs2', 'type': 'VARCHAR'},
            {'field': 'dxccs3', 'type': 'VARCHAR'},
            {'field': 'dxccs4', 'type': 'VARCHAR'},
            {'field': 'dxccs5', 'type': 'VARCHAR'},
            {'field': 'dxccs6', 'type': 'VARCHAR'},
            {'field': 'dxccs7', 'type': 'VARCHAR'},
            {'field': 'dxccs8', 'type': 'VARCHAR'},
            {'field': 'dxccs9', 'type': 'VARCHAR'},
            {'field': 'dxccs10', 'type': 'VARCHAR'},
            {'field': 'dxccs11', 'type': 'VARCHAR'},
            {'field': 'dxccs12', 'type': 'VARCHAR'},
            {'field': 'dxccs13', 'type': 'VARCHAR'},
            {'field': 'dxccs14', 'type': 'VARCHAR'},
            {'field': 'dxccs15', 'type': 'VARCHAR'},
            {'field': 'dxccs16', 'type': 'VARCHAR'},
            {'field': 'dxccs17', 'type': 'VARCHAR'},
            {'field': 'dxccs18', 'type': 'VARCHAR'},
            {'field': 'dxccs19', 'type': 'VARCHAR'},
            {'field': 'dxccs20', 'type': 'VARCHAR'},
            {'field': 'dxccs21', 'type': 'VARCHAR'},
            {'field': 'dxccs22', 'type': 'VARCHAR'},
            {'field': 'dxccs23', 'type': 'VARCHAR'},
            {'field': 'dxccs24', 'type': 'VARCHAR'},
            {'field': 'dxccs25', 'type': 'VARCHAR'},
            {'field': 'prmccs1', 'type': 'VARCHAR'},
            {'field': 'prmccs2', 'type': 'VARCHAR'},
            {'field': 'prmccs3', 'type': 'VARCHAR'},
            {'field': 'prmccs4', 'type': 'VARCHAR'},
            {'field': 'prmccs5', 'type': 'VARCHAR'},
            {'field': 'prmccs6', 'type': 'VARCHAR'},
            {'field': 'prmccs7', 'type': 'VARCHAR'},
            {'field': 'prmccs8', 'type': 'VARCHAR'},
            {'field': 'prmccs9', 'type': 'VARCHAR'},
            {'field': 'prmccs10', 'type': 'VARCHAR'},
            {'field': 'prmccs11', 'type': 'VARCHAR'},
            {'field': 'prmccs12', 'type': 'VARCHAR'},
            {'field': 'prmccs13', 'type': 'VARCHAR'},
            {'field': 'prmccs14', 'type': 'VARCHAR'},
            {'field': 'prmccs15', 'type': 'VARCHAR'},
            {'field': 'prmccs16', 'type': 'VARCHAR'},
            {'field': 'prmccs17', 'type': 'VARCHAR'},
            {'field': 'prmccs18', 'type': 'VARCHAR'},
            {'field': 'prmccs19', 'type': 'VARCHAR'},
            {'field': 'prmccs20', 'type': 'VARCHAR'},
            {'field': 'prmccs21', 'type': 'VARCHAR'},
            {'field': 'prmccs22', 'type': 'VARCHAR'},
            {'field': 'prmccs23', 'type': 'VARCHAR'},
            {'field': 'prmccs24', 'type': 'VARCHAR'},
            {'field': 'prmccs25', 'type': 'VARCHAR'},
            {'field': 'dxmccs1', 'type': 'VARCHAR'},
            {'field': 'dxmccs2', 'type': 'VARCHAR'},
            {'field': 'dxmccs3', 'type': 'VARCHAR'},
            {'field': 'dxmccs4', 'type': 'VARCHAR'},
            {'field': 'dxmccs5', 'type': 'VARCHAR'},
            {'field': 'dxmccs6', 'type': 'VARCHAR'},
            {'field': 'dxmccs7', 'type': 'VARCHAR'},
            {'field': 'dxmccs8', 'type': 'VARCHAR'},
            {'field': 'dxmccs9', 'type': 'VARCHAR'},
            {'field': 'dxmccs10', 'type': 'VARCHAR'},
            {'field': 'dxmccs11', 'type': 'VARCHAR'},
            {'field': 'dxmccs12', 'type': 'VARCHAR'},
            {'field': 'dxmccs13', 'type': 'VARCHAR'},
            {'field': 'dxmccs14', 'type': 'VARCHAR'},
            {'field': 'dxmccs15', 'type': 'VARCHAR'},
            {'field': 'dxmccs16', 'type': 'VARCHAR'},
            {'field': 'dxmccs17', 'type': 'VARCHAR'},
            {'field': 'dxmccs18', 'type': 'VARCHAR'},
            {'field': 'dxmccs19', 'type': 'VARCHAR'},
            {'field': 'dxmccs20', 'type': 'VARCHAR'},
            {'field': 'dxmccs21', 'type': 'VARCHAR'},
            {'field': 'dxmccs22', 'type': 'VARCHAR'},
            {'field': 'dxmccs23', 'type': 'VARCHAR'},
            {'field': 'dxmccs24', 'type': 'VARCHAR'},
            {'field': 'dxmccs25', 'type': 'VARCHAR'}
        ]
    },
    # Long table (lookup table) definitions follow.    
    # If I had more time, these would be drawn from PyHCUP.
    # But their definition in PyHCUP would require a non-
    # trivial amount of reworking to get into a portable
    # format.
    # Alas!
    {
        'name': 'SID Charges (long)',
        'category': 'CHARGES',
        'ds_family_abbr': 'SID', 
        'ds_parent_abbr': 'HCUP', # the parent of the real Definition.data_source
        'columns': [
            {'field': 'KEY', 'type': 'BIGINT'},
            {'field': 'VISITLINK', 'type': 'BIGINT'},
            {'field': 'DAYSTOEVENT', 'type': 'INT'},
            {'field': 'YEAR', 'type': 'INT'},
            {'field': 'STATE', 'type': 'VARCHAR'},
            {'field': 'UNITS', 'type': 'INT'},
            {'field': 'REVCODE', 'type': 'VARCHAR'},
            {'field': 'RATE', 'type': 'NUMERIC(16, 2)'},
            {'field': 'CHARGE', 'type': 'NUMERIC(16, 2)'},
            {'field': 'CPTHCPCS', 'type': 'VARCHAR'},
            {'field': 'CPTMOD1', 'type': 'VARCHAR'},
            {'field': 'CPTMOD2', 'type': 'VARCHAR'},
            {'field': 'GROUP_NUMBER', 'type': 'INT'}
        ]
    },
    {
        'name': 'SID Diagnoses (long)',
        'category': 'DX',
        'ds_family_abbr': 'SID', 
        'ds_parent_abbr': 'HCUP', # the parent of the real Definition.data_source
        'columns': [
            {'field': 'KEY', 'type': 'BIGINT'},
            {'field': 'VISITLINK', 'type': 'BIGINT'},
            {'field': 'DAYSTOEVENT', 'type': 'INT'},
            {'field': 'YEAR', 'type': 'INT'},
            {'field': 'STATE', 'type': 'VARCHAR'},
            {'field': 'DX', 'type': 'VARCHAR'},
            {'field': 'DXV', 'type': 'VARCHAR'},
            {'field': 'DXCCS', 'type': 'VARCHAR'},
            {'field': 'DXPOA', 'type': 'VARCHAR'},
            {'field': 'DXatAdmit', 'type': 'VARCHAR'},
            {'field': 'TMDX', 'type': 'VARCHAR'},
            {'field': 'GROUP_NUMBER', 'type': 'INT'}
        ]
    },
    {
        'name': 'SID Procedures (long)',
        'category': 'PR',
        'ds_family_abbr': 'SID', 
        'ds_parent_abbr': 'HCUP', # the parent of the real Definition.data_source
        'columns': [
            {'field': 'KEY', 'type': 'BIGINT'},
            {'field': 'VISITLINK', 'type': 'BIGINT'},
            {'field': 'DAYSTOEVENT', 'type': 'INT'},
            {'field': 'YEAR', 'type': 'INT'},
            {'field': 'STATE', 'type': 'VARCHAR'},
            {'field': 'PR', 'type': 'VARCHAR'},
            {'field': 'PRCCS', 'type': 'VARCHAR'},
            {'field': 'PRDATE', 'type': 'VARCHAR'},
            {'field': 'PRDAY', 'type': 'INT'},
            {'field': 'PRMONTH', 'type': 'INT'},
            {'field': 'PRYEAR', 'type': 'INT'},
            {'field': 'PRV', 'type': 'VARCHAR'},
            {'field': 'PCLASS', 'type': 'VARCHAR'},
            {'field': 'PRMCCS', 'type': 'VARCHAR'},
            {'field': 'GROUP_NUMBER', 'type': 'INT'}
        ]
    },
    {
        'name': 'SID Utilization Flags (long)',
        'category': 'UFLAGS',
        'ds_family_abbr': 'SID', 
        'ds_parent_abbr': 'HCUP', # the parent of the real Definition.data_source
        'columns': [
            {'field': 'KEY', 'type': 'BIGINT'},
            {'field': 'VISITLINK', 'type': 'BIGINT'},
            {'field': 'DAYSTOEVENT', 'type': 'INT'},
            {'field': 'YEAR', 'type': 'INT'},
            {'field': 'STATE', 'type': 'VARCHAR'},
            {'field': 'NAME', 'type': 'VARCHAR'},
            {'field': 'VALUE', 'type': 'INT'}
        ]
    }
]
